<?php

/**
 * Class for handling the emails
 */
class WC_Custom_Status_Email extends WC_Email {

    var $from_name, $from_email, $custom_info, $display_essential_info;

    function __construct($status_name, $heading, $subject, $from_name, $from_email, $custom_info, $display_essential_info, $custom_email_address='') {
        $this->id               = "{$status_name}_email";
        $this->title            = __( $status_name, 'woocommerce_status_actions' );
        $this->description      = __( "This email is sent when order status is set to {$status_name}", 'woocommerce_status_actions' );

        $this->heading          = __( stripslashes($heading), 'woocommerce_status_actions' );
        $this->subject          = __( stripslashes($subject), 'woocommerce_status_actions' );

        $this->template_html    = 'wc_custom_status_email_html_template.php';
        $this->template_plain   = 'wc_custom_status_email_plain_template.php';

        //Set the email type to html for current requirements, plain text template is also available if needed later
        $this->email_type = 'html';

        $this->from_name = stripslashes($from_name);
        $this->from_email = $from_email;
        $this->custom_info = stripslashes(nl2br($custom_info));
        $this->display_essential_info = $display_essential_info;
        $this->custom_email_address = $custom_email_address;

        parent::__construct();
    }

    function trigger( $order_id, $recipient ) {
        global $woocommerce;

        if ( $order_id ) {
            $this->object = new WC_Order( $order_id );
            if($recipient == 'customer'){
                $this->recipient = $this->object->billing_email;
            } else if($recipient == 'admin'){
                $this->recipient = get_option('admin_email');
            } else if($recipient == 'custom'){
                $this->recipient = $this->custom_email_address;
            } else {
                return;
            }

            //Process shortcodes
            $shortcodes[] = '{order_date}';
            $replacements[] = date_i18n( woocommerce_date_format(), strtotime( $this->object->order_date ) );

            $shortcodes[] = '{order_number}';
            $replacements[] = $this->object->get_order_number();

            $shortcodes[] = '{order_value}';
            $replacements[] = $this->object->order_total;

            $shortcodes[] = '{billing_address}';
            $replacements[] = $this->object->get_formatted_billing_address();

            $shortcodes[] = '{shipping_address}';
            $replacements[] = $this->object->get_formatted_shipping_address();

            $customer_first_name = "";
            $customer_last_name = "";
            $customer_user_object = get_user_by('id', $this->object->customer_user);
            if($customer_user_object){
                $customer_first_name = $customer_user_object->get('first_name');
                $customer_last_name = $customer_user_object->get('last_name');
            }
            $shortcodes[] = '{customer_first_name}';
            $replacements[] = stripslashes( $customer_first_name );
            $shortcodes[] = '{customer_last_name}';
            $replacements[] = stripslashes( $customer_last_name );

            $this->custom_info = str_replace($shortcodes,$replacements,$this->custom_info);

            $this->heading = str_replace($shortcodes,$replacements,$this->heading);
            $this->subject = str_replace($shortcodes,$replacements,$this->subject);
        }

        //No recipient is defined
        if ( ! $this->get_recipient() )
            return;

        $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
    }

    function get_content_html() {
        ob_start();
        extract(array(
            'order'         => $this->object,
            'email_heading' => $this->get_heading(),
            'custom_info'   => $this->custom_info,
            'display_essential_info'=> $this->display_essential_info
        ) );
        include dirname(__FILE__) . '/wc_custom_status_email_html_template.php';
        return ob_get_clean();
    }

    function get_from_address() {
        return sanitize_email( $this->from_email );
    }

    function get_from_name() {
        return wp_specialchars_decode(stripslashes($this->from_name), ENT_QUOTES);
    }
}
?>