<?php

require_once("../../../wp-config.php");
$wp->init();
$wp->parse_request();
$wp->query_posts();
$wp->register_globals();
$wp->send_headers();

if (isset($_GET['action'])&&$_GET['action'] == "get_customizer_url") 
{
    $variation_id=$_GET['variation_id'];
    $url=get_wpc_url($variation_id);
    echo json_encode(array("url"=>$url));
}

else if(
        (isset($_POST['action'])&&$_POST['action']=="handle_picture_upload")
        ||
        (isset($_FILES['userfile']) && $_FILES['userfile']['error'] == 0)
       )
{
    $upload_dir=  wp_upload_dir();
    $generation_path = $upload_dir["basedir"];
    $generation_url = $upload_dir["baseurl"];
    $file_name=  uniqid();
    $valid_formats=  get_option("wpc-upl-extensions");
    if(!$valid_formats)
        $valid_formats = array("jpg", "png", "gif", "bmp","jpeg");//wpc-upl-extensions
//    var_dump($valid_formats);
    $name = $_FILES['userfile']['name'];
    $size = $_FILES['userfile']['size'];
    
    if(isset($_POST) and $_SERVER['REQUEST_METHOD'] == "POST")
    {
    
    if(strlen($name))
    {
        list($txt, $ext) = explode(".", $name);
        $ext=  strtolower($ext);
        if(in_array($ext,$valid_formats))
        {
                $tmp = $_FILES['userfile']['tmp_name'];
                $success=0;
                $message="";
                if(move_uploaded_file($tmp, $generation_path."/".$file_name.".$ext"))
                {
                    $min_width=  get_option("wpc-min-upload-width");
                    $min_height=  get_option("wpc-min-upload-height");
                    if($min_width>0||$min_height>0)
                    {
                        list($width, $height, $type, $attr) = getimagesize($generation_path."/".$file_name.".$ext");
                        if(($min_width>$width||$min_height>$height)&&$ext!="svg")
                        {
                            $success=0;
                            $message=sprintf( __( 'Uploaded file dimensions: %1$spx x %2$spx, minimum required ', 'wpc' ), $width, $height );
                            if($min_width>0&&$min_height>0)
                                $message.="dimensions: $min_height"."px"." x $min_height"."px";
                            else if($min_width>0)
                                $message.="width: $min_width"."px";
                            else if($min_height>0)
                                $message.="height: $min_height"."px";
                        }
                        else
                        {
                            $success=1;
                            $message="<span class='clipart-img'><img src='$generation_url/$file_name.$ext'></span>";
                        }
                        
                    }
                    else                    
                    {
                        $success=1;
                        $message="<span class='clipart-img'><img src='$generation_url/$file_name.$ext'></span>";
                    }
                    if($success==0)
                        unlink ($generation_path."/".$file_name.".$ext");
                }
                else
                {
                    $success=0;
                    $message=__( 'An error occured during the upload. Please try again later', 'wpc' );
                }
        }
        else
        {
            $success=0;
            $message=__( 'Incorrect file extension. Allowed extensions: ', 'wpc' ).  implode(", ", $valid_formats);
        }
        echo json_encode(
                            array(
                                    "success"=>$success,
                                    "message"=>$message,
                            )
                        );
    }
    }
}

else if(isset($_POST['action'])&&$_POST['action']=="handle-custom-design-upload"
        ||
        (isset($_FILES['user-custom-design']) && $_FILES['user-custom-design']['error'] == 0))
{
    $upload_dir=  wp_upload_dir();
    $product_id=$_POST["wpc-product-id-upl"];
    $generation_path = $upload_dir["basedir"];
    $generation_url = $upload_dir["baseurl"];
    $file_name=  uniqid();
    $valid_formats=array();
    $valid_formats_raw=  get_option("wpc-custom-designs-extensions");
    if(!empty($valid_formats_raw))
    {
        $valid_formats=array_map('trim', explode(',', $valid_formats_raw));
    }
    $name = $_FILES['user-custom-design']['name'];
    $size = $_FILES['user-custom-design']['size'];
    
    if(isset($_POST) and $_SERVER['REQUEST_METHOD'] == "POST")
    {
    
    if(strlen($name))
    {
        if(!isset($_SESSION["wpc-user-uploaded-designs"]))
            $_SESSION["wpc-user-uploaded-designs"]=array();
        
        if(isset($_SESSION["wpc-user-uploaded-designs"][$product_id]))
            unset($_SESSION["wpc-user-uploaded-designs"][$product_id]);
        
        list($txt, $ext) = explode(".", $name);
        $ext=  strtolower($ext);
        if(in_array($ext,$valid_formats)||empty($valid_formats))
        {
//            var_dump($_FILES);
            $tmp = $_FILES['user-custom-design']['tmp_name'];
            $success=0;
            $message="";
            if(move_uploaded_file($tmp, $generation_path."/".$file_name.".$ext"))
            {
                $success=1;
                $_SESSION["wpc-user-uploaded-designs"][$product_id]="$generation_url/$file_name.$ext";
                $message=$_FILES['user-custom-design']['name']." successfully uploaded. Click on the Add to cart button to add this product and your design to the cart.";
            }
            else
            {
                $success=0;
                $message=__( 'An error occured during the upload. Please try again later', 'wpc' );
            }
        }
        else if(!in_array($ext,$valid_formats))
        {
            $success=0;
            $message=__( 'Incorrect file extension. Allowed extensions: ', 'wpc' ).  implode(", ", $valid_formats);            
        }
        echo json_encode(
                            array(
                                    "success"=>$success,
                                    "message"=>$message,
                            )
                        );
    }
    }
}

else if(isset($_POST['action'])&&$_POST['action']=="add_custom_design_to_cart")
{
    global $woocommerce;
    $cart_url = $woocommerce->cart->get_cart_url();
    $final_canvas_parts=$_POST["final_canvas_parts"];
    $variation_id=$_POST["variation_id"];
    $quantity=$_POST["quantity"];
    $cart_item_key=$_POST["cart_item_key"];
    if($cart_item_key)
    {
        $_SESSION["wpc_generated_data"][$variation_id][$cart_item_key]=$final_canvas_parts;
        $result=true;
        $message="<div class='wpc_notification success f-right'>Item successfully updated. <a href='$cart_url'>View Cart</a></div>";
    }
    else
    {
        $variable_product=get_product($variation_id);
        if($variable_product->product_type=="simple")
            $product_id=$variation_id;
        else
            $product_id=$variable_product->parent->id;
        $result=$woocommerce->cart->add_to_cart( $product_id, $quantity, $variation_id, "wpc_data", $final_canvas_parts);
        if($result)
            $message="<div class='wpc_notification success f-right'>".__( "Product successfully added to basket.","wpc")." <a href='$cart_url'>View Cart</a></div>";
        else
            $message="<div class='wpc_notification failure f-right'>".__( "A problem occured. Please try again.","wpc")."</div>";
    }
    echo json_encode(array("success"=>$result,
                           "message"=>$message));
    
}

else if(isset($_POST['action'])&&$_POST['action']=="save_custom_design_for_later")
{
    $final_canvas_parts=$_POST["final_canvas_parts"];
    $variation_id=$_POST["variation_id"];
    $cart_item_key="";
    if(isset($_POST["cart_item_key"]))
        $cart_item_key=$_POST["cart_item_key"];
    $is_logged=0;
    $result=0;
    $message="";
    $url=wp_login_url(get_wpc_url($variation_id));
    if(is_user_logged_in())
    {
        global $current_user;
        get_currentuserinfo();
        $message=$current_user->ID;
        $is_logged=1;
        $today = date("Y-m-d H:i:s");     
        $result=add_user_meta($current_user->ID, "wpc_saved_designs", array($variation_id,$today,$final_canvas_parts));
        if($result)
        {
            $result=1;
            $message="<div class='wpc_notification success'>".__( "The design has successfully been saved to your account.","wpc")."</div>";
            $user_designs=get_user_meta($current_user->ID, 'wpc_saved_designs');
            $newly_added_index=  count($user_designs)-1;
            $url=get_wpc_url($variation_id)."&design_index=".$newly_added_index;
        }
        else
        {
            $result=0;
            $message="<div class='wpc_notification failure'>".__( "An error has occured. Please try again later or contact the administrator.","wpc")."</div>";
        }
    }
    else
    {
        if(!isset($_SESSION['wpc_designs_to_save']))
            $_SESSION['wpc_designs_to_save']=array();
        if(!isset($_SESSION['wpc_designs_to_save'][$variation_id]))
            $_SESSION['wpc_designs_to_save'][$variation_id]=array();
        
        array_push($_SESSION['wpc_designs_to_save'][$variation_id], $final_canvas_parts);
    }
    echo json_encode(array( "is_logged"=>$is_logged,
                            "success"=>$result,
                            "message"=>$message,
                            "url"=>$url
                            )
                    );
    
}

else if(isset($_POST['action'])&&$_POST['action']=="save_canvas_to_session")
{
    $final_canvas_parts=$_POST["final_canvas_parts"];
    $template_object = get_post_type_object( "wpc-template" );
    $can_manage_templates=  current_user_can( $template_object->cap->edit_posts );
    if($can_manage_templates)
    {
        $_SESSION["to_save"]=$final_canvas_parts;
    }   
}

else if(isset($_POST['action'])&&$_POST['action']=="generate_downloadable_file")
{
    $final_canvas_parts=$_POST["final_canvas_parts"];
    $tmp_dir=  uniqid();
    $upload_dir=  wp_upload_dir();
    $generation_path = $upload_dir["basedir"]."/WPC/$tmp_dir";
    $generation_url = $upload_dir["baseurl"]."/WPC/$tmp_dir";
    $variation_id=$_POST["variation_id"];
    if(wp_mkdir_p($generation_path))
    {
        $generation_url = $upload_dir["baseurl"]."/WPC/$tmp_dir";

        $result=export_data_to_files($generation_path, $final_canvas_parts, $generation_url, false, $variation_id);
        if($result)
            echo json_encode(array(
                "success"=>1,
                "message"=>"<div class='wpc-success'>".$result."</div>",
                    )
                );
        else
            echo json_encode(array(
                "success"=>0,
                "message"=>"<div class='wpc-failure'>".__( "An error occured in the generation process. Please try again later.","wpc")."</div>",
                    )
                );
    }
    else
        echo json_encode(array(
                "success"=>0,
                "message"=>"<div class='wpc-failure'>".__( "Can't create a generation directory...","wpc")."</div>",
                    )
                );
}

else if(isset($_POST['action'])&&$_POST['action']=="get_design_price")
{
    $variation_id=$_POST["variation_id"];
    $serialized_parts=$_POST["serialized_parts"];
    $product=get_product($variation_id);
    $product_price=$product->price;
    $a_price=get_wpc_additional_price($variation_id, $serialized_parts);
    echo json_encode(array(
                "price"=>$a_price+$product_price
                    )
                );
}
else if (isset($_GET['action'])&&$_GET['action'] == "delete_saved_design") 
{
    $design_index=$_GET['design_index'];
    $variation_id=$_GET['variation_id'];
    global $current_user;
    $user_designs=get_user_meta($current_user->ID, 'wpc_saved_designs');
    $target=$user_designs[$design_index];
    //WP unslashes every elements in delete_user_meta. This handles the multilines text issues on removal.
    foreach ($target[2] as $key=>$value)
    {
        $json=$target[2][$key]["json"];
        $json=  str_replace('\n', '\\\n', $json);
        $target[2][$key]["json"]=$json;
    }
    $result=delete_user_meta($current_user->ID, "wpc_saved_designs",$target);
    $url=  get_wpc_url($variation_id);
    
    echo json_encode(array(
        "success"=>$result,
        "url"=>$url,
        "message"=>__( 'An error occured. Please try again later', 'wpc' )
        ));
}

else if (isset($_POST['action'])&&$_POST['action'] == "get_wpc_product_tab_data_content") 
{
    $product_id=$_POST["product_id"];
    $post_type=$_POST["post_type"];
    $variations_arr=array();
    if(isset($_POST["variations"]))
        $variations_arr=$_POST["variations"];        
    get_wpc_product_tab_data_content_ajx($product_id, $post_type, $variations_arr);
}

?>