<?php
// Direct access security
if ( !defined( 'TM_EPO_PLUGIN_SECURITY' ) ) {
	die();
}

/**
 * TM_Extra_Product_Options Class
 *
 * This class is responsible for displaying the Extra Product Options on the frontend.
 */

class TM_Extra_Product_Options {

	var $version        = '2.0.0';
	var $_namespace     = 'tm-extra-product-options';
	var $plugin_path;
	var $template_path;
	var $plugin_url;
	var $display 		= 'normal';
	var $tm_meta_cpf = array();
	var $element_post_types;
	var $inline_styles;
	var $tm_epo_force_select_options;
	var $tm_epo_final_total_box;
	var $tm_epo_clear_cart_button;
	var $tm_epo_cart_field_display;
	var $meta_fields = array(
			'exclude' => '',
			'override_display' => ''
		);
	public function __construct() {
		$this->plugin_path      			= untrailingslashit( plugin_dir_path(  __FILE__  ) );
		$this->template_path    			= $this->plugin_path.'/templates/';
		$this->plugin_url       			= untrailingslashit( plugins_url( '/', __FILE__ ) );
		$this->inline_styles 				= '';
		$this->element_post_types 			= array("checkbox","radio","select","textarea","textfield","upload");
		$this->tm_epo_force_select_options 	= get_option( 'tm_epo_force_select_options' );
		$this->tm_epo_final_total_box 		= get_option( 'tm_epo_final_total_box' );
		$this->tm_epo_clear_cart_button 	= get_option( 'tm_epo_clear_cart_button' );
		$this->tm_epo_cart_field_display 	= get_option( 'tm_epo_cart_field_display' );
		$this->display 						= get_option( 'tm_epo_display' );
		
		if (!$this->tm_epo_force_select_options){
			$this->tm_epo_force_select_options = 'normal';
		}
		if (!$this->tm_epo_final_total_box){
			$this->tm_epo_final_total_box = 'normal';
		}
		if (!$this->tm_epo_clear_cart_button){
			$this->tm_epo_clear_cart_button = 'normal';
		}
		if (!$this->tm_epo_cart_field_display){
			$this->tm_epo_cart_field_display = 'normal';
		}
		if (!$this->display){
			$this->display = 'normal';
		}

		foreach ( $this->meta_fields as $key=>$value ) {
			$this->tm_meta_cpf[$key] = $value;
		}

		add_action( 'wp', array( $this, 'init_settings' ) );

		/**
		 * Load js,css files
		 */
		add_action( 'wp_enqueue_scripts', array( $this, 'frontend_scripts' ) );
		add_action( 'woocommerce_tm_custom_price_fields_enqueue_scripts', array( $this, 'custom_frontend_scripts' ) );
		add_action( 'woocommerce_tm_epo_enqueue_scripts', array( $this, 'custom_frontend_scripts' ) );

		/**
		 * Display in frontend
		 */
		add_action( 'woocommerce_tm_custom_price_fields', array( $this, 'frontend_display' ) );
		add_action( 'woocommerce_tm_custom_price_fields_only', array( $this, 'tm_epo_fields' ) );
		add_action( 'woocommerce_tm_custom_price_fields_totals', array( $this, 'tm_epo_totals' ) );

		add_action( 'woocommerce_tm_epo', array( $this, 'frontend_display' ) );
		add_action( 'woocommerce_tm_epo_fields', array( $this, 'tm_epo_fields' ) );
		add_action( 'woocommerce_tm_epo_totals', array( $this, 'tm_epo_totals' ) );

		/**
		 * Composite Products Support
		 */
		add_action( 'woocommerce_composite_product_add_to_cart', array( $this, 'tm_bto_display_support' ), 11, 2 );

		/**
		 * Cart manipulation
		 */
		add_filter( 'woocommerce_add_cart_item', array( &$this, 'add_cart_item' ), 50, 1 );
		add_filter( 'woocommerce_get_cart_item_from_session', array( &$this, 'get_cart_item_from_session' ), 50, 2 );
		add_filter( 'woocommerce_get_item_data', array( &$this, 'get_item_data' ), 50, 2 );
		add_filter( 'woocommerce_add_cart_item_data', array( &$this, 'add_cart_item_data' ), 50, 2 );
		add_action( 'woocommerce_add_order_item_meta', array( $this, 'order_item_meta' ), 50, 2 );
		add_filter( 'woocommerce_add_to_cart_validation', array( &$this, 'add_to_cart_validation' ), 50, 6 );
		add_filter( 'woocommerce_order_again_cart_item_data', array( $this, 'order_again_cart_item_data' ), 50, 3 );

		/**
		 * Empty cart button
		 */
		if ($this->tm_epo_clear_cart_button=="show"){
			add_action( 'woocommerce_proceed_to_checkout', array( $this, 'add_empty_cart_button' ) );
			// check for empty-cart get param to clear the cart
			add_action( 'init', array( $this, 'clear_cart' ) );
		}

		/**
		 * Force Select Options
		 */
		add_filter( 'woocommerce_add_to_cart_url', array( $this, 'add_to_cart_url' ), 50, 1 );
		add_filter( 'woocommerce_product_add_to_cart_url', array( $this, 'add_to_cart_url' ), 50, 1 );
		add_action( 'woocommerce_product_add_to_cart_text', array( $this, 'add_to_cart_text' ), 10, 1 );

		
	}

	public function add_to_cart_text( $text ) {
		global $product;

		if ( $this->tm_epo_force_select_options=="display" ) {
			$cpf=$this->get_product_tm_epos($product->id);
			if (is_array($cpf) && (!empty($cpf['global']) || !empty($cpf['local']))) {
				$text = __( 'Select options', 'woocommerce' );
			}
		}

		return $text;
	}

	public function add_to_cart_url( $url ) {
		global $product;

		if ( $this->tm_epo_force_select_options=="display" ) {
			$cpf=$this->get_product_tm_epos($product->id);
			if (is_array($cpf) && (!empty($cpf['global']) || !empty($cpf['local']))) {
				$url = get_permalink( $product->id );
			}
		}

		return $url;
	}

	public function clear_cart() {
		global $woocommerce;
		if ( isset( $_POST['tm_empty_cart'] ) ) {
			$woocommerce->cart->empty_cart();
		}
	}

	public function add_empty_cart_button(){
		echo '<input type="submit" class="tm-clear-cart-button checkout-button button wc-forward" name="tm_empty_cart" value="'.__( 'Empty cart', TM_EPO_TRANSLATION ).'" />';
	}

	private function set_tm_meta(){
		global $post;
		if (!is_null($post) && property_exists($post,'ID')){
			$this->tm_meta_cpf = get_post_meta( $post->ID, 'tm_meta_cpf', true );
		}		
		
		foreach ( $this->meta_fields as $key=>$value ) {
			$this->tm_meta_cpf[$key] = isset( $this->tm_meta_cpf[$key] ) ? $this->tm_meta_cpf[$key] : $value;
		}	
	}

	/**
	 * Initialize custom product settings
	 */
	public function init_settings(){
		/* post_max_size debug */
		if(empty($_FILES) 
			&& empty($_POST) 
			&& isset($_SERVER['REQUEST_METHOD']) 
			&& strtolower($_SERVER['REQUEST_METHOD']) == 'post'){

        	$postMax = ini_get('post_max_size');
			wc_add_notice( sprintf( __( 'Trying to upload files larger than %s is not allowed!', TM_EPO_TRANSLATION ), $postMax ) , 'error' );
		}

		global $post,$product;
		$this->set_tm_meta();			

		if (($this->display=='normal' || $this->tm_meta_cpf['override_display']=='normal') && $this->tm_meta_cpf['override_display']!='action'){
			add_action( 'woocommerce_before_add_to_cart_button', array( $this, 'frontend_display' ), 50 );
		}
	}

	public function tm_bto_display_support( $product_id, $item_id ) {
		global $product;

		if (!$product){
			$product = get_product( $product_id );
		}
	    if (!$product){
	        // something went wrong. wrond product id??
	        // if you get here the plugin will not work :(
	    }else{
	    	$this->tm_meta_cpf = get_post_meta( $product_id, 'tm_meta_cpf', true );
	    	$meta_fields = array(
				'exclude' => '',
				'override_display' => ''
			);
			
			foreach ( $meta_fields as $key=>$value ) {
				$this->tm_meta_cpf[$key] = isset( $this->tm_meta_cpf[$key] ) ? $this->tm_meta_cpf[$key] : $value;
			}
			if (($this->display=='normal' || $this->tm_meta_cpf['override_display']=='normal') && $this->tm_meta_cpf['override_display']!='action'){		
				$this->frontend_display($product_id, $item_id);
			}
		}
	}

	private function _tm_temp_uniqid($s){
		$a=array();
		for ( $m = 0; $m < $s; $m++ ) {
			$a[]=uniqid('', true);
		}
		return $a;
	}

	/**
	 * Gets a list of all the Extra Product Options (local and global)
	 * for the specific $post_id.
	 */
	public function get_product_tm_epos( $post_id=0 ) {
		if ( empty( $post_id ) ) {
			return array();
		}

		$in_cat="";

		$terms = get_the_terms( $post_id, 'product_cat' );
		if ( $terms ) {
			foreach ( $terms as $term ) {
				$in_cat[] = $term->term_id;
			}
		}

		$_all_categories = get_terms( 'product_cat', array( 'fields' => "ids" ) );
		if ( !$_all_categories ) {
			$_all_categories = array();
		}

		$args = array(
			'post_type'     => TM_EPO_LOCAL_POST_TYPE,
			'post_status'   => array( 'publish' ), // get only enabled extra options
			'numberposts'   => -1,
			'orderby'       => 'menu_order',
			'order'       	=> 'asc',
			'post_parent'   => $post_id
		);
		$tmlocalprices = get_posts( $args );

		$args = array(
			'post_type'     => TM_EPO_GLOBAL_POST_TYPE,
			'post_status'   => array( 'publish' ), // get only enabled global extra options
			'numberposts'   => -1,
			'orderby'       => 'date',
			'order'       	=> 'asc',
			'tax_query'		=> array(
				array(
					'field' 			=> 'term_id',
					'taxonomy' 			=> 'product_cat',
					'terms' 			=> $_all_categories,
					'include_children' 	=> false,
					'operator'			=> 'NOT IN'
				)
			)
		);
		$tmglobalprices_empty = get_posts( $args );

		$args = array(
			'post_type'     => TM_EPO_GLOBAL_POST_TYPE,
			'post_status'   => array( 'publish' ), // get only enabled global extra options
			'numberposts'   => -1,
			'orderby'       => 'date',
			'order'       	=> 'asc',
			'tax_query'		=> array(
				array(
					'field' 			=> 'term_id',
					'taxonomy' 			=> 'product_cat',
					'terms' 			=> $in_cat,
					'include_children' 	=> false,
					'operator'			=> 'IN'
				)
			)
		);
		$tmglobalprices = get_posts( $args );
		if ( $tmglobalprices_empty ) {
			foreach ( $tmglobalprices_empty as $price ) {
				$tmglobalprices[]=$price;
			}
		}

		$product_epos=array();
		$global_epos=array();

		if ( $tmglobalprices ) {
			foreach ( $tmglobalprices as $price ) {
				$tmcp_id  	= absint( $price->ID );
				$tmcp_meta	= get_post_meta( $price->ID, 'tm_meta', true );
				$priority  	= isset( $tmcp_meta['priority'] )?absint( $tmcp_meta['priority'] ):1000;

				$global_epos[$priority][$tmcp_id]['is_form']   	= 1;
				$global_epos[$priority][$tmcp_id]['is_taxonomy'] 	= 0;
				$global_epos[$priority][$tmcp_id]['name']    		= $price->post_title;
				$global_epos[$priority][$tmcp_id]['description'] 	= $price->post_excerpt;
				$global_epos[$priority][$tmcp_id]['sections'] 		= array();

				if ( isset( $tmcp_meta['tmfbuilder'] ) ) {
					$builder=$tmcp_meta['tmfbuilder'];
					if ( is_array( $builder ) && count( $builder )>0 && isset( $builder['element_type'] ) && is_array( $builder['element_type'] ) && count( $builder['element_type'] )>0 ) {
						// All the elements
						$_elements=$builder['element_type'];
						// All element sizes
						$_div_size=$builder['div_size'];

						// All sections (holds element count for each section)
						$_sections=$builder['sections'];
						// All section sizes
						$_sections_size=$builder['sections_size'];
						// All section styles
						$_sections_style=$builder['sections_style'];
						// All section placements
						$_sections_placement=$builder['sections_placement'];


						if ( !is_array( $_sections ) ) {
							$_sections=array( count( $_elements ) );
						}
						if ( !is_array( $_sections_size ) ) {
							$_sections_size=array_fill(0, count( $_sections ) ,"w100");
						}
						if ( !is_array( $_sections_style ) ) {
							$_sections_style=array_fill(0, count( $_sections ) ,"");
						}
						if ( !is_array( $_sections_placement ) ) {
							$_sections_placement=array_fill(0, count( $_sections ) ,"before");
						}
						
						$_sections_uniqid 	= isset($builder['sections_uniqid'])?$builder['sections_uniqid']:$this->_tm_temp_uniqid(count( $_sections )) ;
						$_sections_clogic 	= isset($builder['sections_clogic'])?$builder['sections_clogic']:array_fill(0, count( $_sections ) ,false);
						$_sections_logic 	= isset($builder['sections_logic'])?$builder['sections_logic']:array_fill(0, count( $_sections ) ,"");
						

						$_helper_counter=0;
						$_counter=array();

						for ( $_s = 0; $_s < count( $_sections ); $_s++ ) {
							$global_epos[$priority][$tmcp_id]['sections'][$_s]=array(
								'total_elements'		=> $_sections[$_s],
								'sections_size'			=> $_sections_size[$_s],
								'sections_style'		=> $_sections_style[$_s],
								'sections_placement'	=> $_sections_placement[$_s],
								'sections_uniqid'		=> $_sections_uniqid[$_s],
								'sections_clogic'		=> $_sections_clogic[$_s],
								'sections_logic'		=> $_sections_logic[$_s],

								'label_size'			=> isset( $builder['section_header_size'][$_s])?$builder['section_header_size'][$_s]:"",
								'label'					=> isset( $builder['section_header_title'][$_s])?$builder['section_header_title'][$_s]:"",
								'label_color'			=> isset( $builder['section_header_title_color'][$_s])?$builder['section_header_title_color'][$_s]:"",
								'description'			=> isset( $builder['section_header_subtitle'][$_s])?$builder['section_header_subtitle'][$_s]:"",
								'description_color'		=> isset( $builder['section_header_subtitle_color'][$_s])?$builder['section_header_subtitle_color'][$_s]:"",
								'divider_type'			=> isset( $builder['section_divider_type'][$_s])?$builder['section_divider_type'][$_s]:""

							);

							for ( $k0 = $_helper_counter; $k0 < intval( $_helper_counter+intval( $_sections[$_s] ) ); $k0++ ) {
								if ( isset( $_elements[$k0] ) ) {
									if ( !isset( $_counter[$_elements[$k0]] ) ) {
										$_counter[$_elements[$k0]]=0;
									}else {
										$_counter[$_elements[$k0]]++;
									}

									$_options=array();									
									$_regular_price=array();
									$_regular_price_type=array();
									$_new_type=$_elements[$k0];
									$_prefix="";

									switch ( $_elements[$k0] ) {

									case "textarea":
									case "textfield":
									case "upload":
										$_prefix=$_elements[$k0]."_";
										if ( empty( $builder[$_elements[$k0].'_price'][$_counter[$_elements[$k0]]] ) ) {
											$builder[$_elements[$k0].'_price'][$_counter[$_elements[$k0]]]=0;
										}
										$_regular_price=array( array( wc_format_decimal( $builder[$_elements[$k0].'_price'][$_counter[$_elements[$k0]]] ) ) );
										$_regular_price_type=isset($builder[$_elements[$k0].'_price_type'][$_counter[$_elements[$k0]]])?array( array( ( $builder[$_elements[$k0].'_price_type'][$_counter[$_elements[$k0]]] ) ) ):array();
										break;

									case "selectbox":
									case "radiobuttons":
									case "checkboxes":
										$_prefix=$_elements[$k0]."_";
										if ( isset( $builder['multiple_'.$_elements[$k0].'_options_price'][$_counter[$_elements[$k0]]] ) ) {
											if ( empty( $builder['multiple_'.$_elements[$k0].'_options_price'][$_counter[$_elements[$k0]]] ) ) {
												$builder['multiple_'.$_elements[$k0].'_options_price'][$_counter[$_elements[$k0]]]=0;
											}
											$_prices=$builder['multiple_'.$_elements[$k0].'_options_price'][$_counter[$_elements[$k0]]];
											$_values=$builder['multiple_'.$_elements[$k0].'_options_value'][$_counter[$_elements[$k0]]];
											$_titles=$builder['multiple_'.$_elements[$k0].'_options_title'][$_counter[$_elements[$k0]]];
											$_images=isset($builder['multiple_'.$_elements[$k0].'_options_image'][$_counter[$_elements[$k0]]])?$builder['multiple_'.$_elements[$k0].'_options_image'][$_counter[$_elements[$k0]]]:array();
											$_prices_type=isset($builder['multiple_'.$_elements[$k0].'_options_price_type'][$_counter[$_elements[$k0]]])?$builder['multiple_'.$_elements[$k0].'_options_price_type'][$_counter[$_elements[$k0]]]:array();
											$_regular_price=array();
											$_regular_price_type=array();
											$_values_c=$_values;
											foreach ( $_prices as $_n=>$_price ) {
												$_regular_price[esc_attr( sanitize_title( $_values[$_n] ) )."_".$_n]=array( wc_format_decimal( $_price ) );
												$_regular_price_type[esc_attr( sanitize_title( $_values[$_n] ) )."_".$_n]=isset($_prices_type[$_n])?array( ( $_prices_type[$_n] ) ):array('');
												$_options[esc_attr( sanitize_title( $_values[$_n] ) )."_".$_n]=$_titles[$_n];	
												$_values_c[$_n]=$_values[$_n]."_".$_n;
											}
										}
										break;

									}

									switch ( $_elements[$k0] ) {

									case "selectbox":
										$_new_type="select";
										break;

									case "radiobuttons":
										$_new_type="radio";
										break;

									case "checkboxes":
										$_new_type="checkbox";
										break;

									}

									$_rules=$_regular_price;
									foreach ( $_regular_price as $key=>$value ) {
										foreach ( $value as $k=>$v ) {
											$_regular_price[$key][$k]=wc_format_localized_price( $v );
										}
									}
									$_rules_type=$_regular_price_type;
									foreach ( $_regular_price_type as $key=>$value ) {
										foreach ( $value as $k=>$v ) {
											$_regular_price_type[$key][$k]= $v ;
										}
									}

									switch ( $_elements[$k0] ) {

									case "upload":
									case "textarea":
									case "textfield":
									case "selectbox":
									case "radiobuttons":
									case "checkboxes":
										$global_epos[$priority][$tmcp_id]['sections'][$_s]['elements'][]=array(
											'type'				=> $_new_type,
											'size'				=> $_div_size[$k0],
											'required'			=> isset( $builder[$_prefix.'required'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'required'][$_counter[$_elements[$k0]]]:"",
											'use_images'		=> isset( $builder[$_prefix.'use_images'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'use_images'][$_counter[$_elements[$k0]]]:"",
											'items_per_row'		=> isset( $builder[$_prefix.'items_per_row'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'items_per_row'][$_counter[$_elements[$k0]]]:"",
											'label_size'		=> isset( $builder[$_prefix.'header_size'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_size'][$_counter[$_elements[$k0]]]:"",
											'label'				=> isset( $builder[$_prefix.'header_title'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_title'][$_counter[$_elements[$k0]]]:"",
											'label_color'		=> isset( $builder[$_prefix.'header_title_color'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_title_color'][$_counter[$_elements[$k0]]]:"",
											'description'		=> isset( $builder[$_prefix.'header_subtitle'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_subtitle'][$_counter[$_elements[$k0]]]:"",
											'description_color'	=> isset( $builder[$_prefix.'header_subtitle_color'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_subtitle_color'][$_counter[$_elements[$k0]]]:"",
											'divider_type'		=> isset( $builder[$_prefix.'divider_type'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'divider_type'][$_counter[$_elements[$k0]]]:"",
											'placeholder'		=> isset( $builder[$_prefix.'placeholder'][$_counter[$_elements[$k0]]] )?$builder[$_prefix.'placeholder'][$_counter[$_elements[$k0]]]:"",
											'max_chars'			=> isset( $builder[$_prefix.'max_chars'][$_counter[$_elements[$k0]]] )?$builder[$_prefix.'max_chars'][$_counter[$_elements[$k0]]]:"",
											'hide_amount'		=> isset( $builder[$_prefix.'hide_amount'][$_counter[$_elements[$k0]]] )?$builder[$_prefix.'hide_amount'][$_counter[$_elements[$k0]]]:"",
											'options'			=> $_options,
											'rules'				=> $_rules,
											'price_rules'		=> $_regular_price,
											'price_rules_type'	=> $_regular_price_type,
											'rules_type'		=> $_rules_type,
											'images'			=> isset($_images)?$_images:"",
											'limit'				=> isset( $builder[$_prefix.'limit_choices'][$_counter[$_elements[$k0]]] )?$builder[$_prefix.'limit_choices'][$_counter[$_elements[$k0]]]:"",
											'option_values'		=> isset($_values_c)?$_values_c:array(),
											'button_type'=> isset( $builder[$_prefix.'button_type'][$_counter[$_elements[$k0]]] )?$builder[$_prefix.'button_type'][$_counter[$_elements[$k0]]]:"",
											'uniqid' 			=> isset($builder[$_prefix.'uniqid'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'uniqid'][$_counter[$_elements[$k0]]]:uniqid('', true) ,
											'clogic' 			=> isset($builder[$_prefix.'clogic'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'clogic'][$_counter[$_elements[$k0]]]:false,
											'logic' 			=> isset($builder[$_prefix.'logic'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'logic'][$_counter[$_elements[$k0]]]:""

										);
										break;

									case "header":
										$global_epos[$priority][$tmcp_id]['sections'][$_s]['elements'][]=array(
											'type'				=> $_new_type,
											'size'				=> $_div_size[$k0],
											'required'			=> "",
											'use_images' 		=> "",
											'items_per_row' 	=> "",
											'label_size'		=> isset( $builder[$_prefix.'header_size'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_size'][$_counter[$_elements[$k0]]]:"",
											'label'				=> isset( $builder[$_prefix.'header_title'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_title'][$_counter[$_elements[$k0]]]:"",
											'label_color'		=> isset( $builder[$_prefix.'header_title_color'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_title_color'][$_counter[$_elements[$k0]]]:"",
											'description'		=> isset( $builder[$_prefix.'header_subtitle'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_subtitle'][$_counter[$_elements[$k0]]]:"",
											'description_color'	=> isset( $builder[$_prefix.'header_subtitle_color'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'header_subtitle_color'][$_counter[$_elements[$k0]]]:"",
											'divider_type'		=> "",
											'placeholder'		=> "",
											'max_chars'			=> "",
											'hide_amount'		=> "",
											"options"			=> $_options,
											'rules'				=> $_rules,
											'price_rules'		=> $_regular_price,
											'price_rules_type'	=> $_regular_price_type,
											'rules_type'		=> $_rules_type,
											'images'			=> "",
											'limit'				=> "",
											'option_values'		=> array(),
											'button_type'=>'',
											'uniqid' 			=> isset($builder[$_prefix.'uniqid'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'uniqid'][$_counter[$_elements[$k0]]]:uniqid('', true) ,
											'clogic' 			=> isset($builder[$_prefix.'clogic'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'clogic'][$_counter[$_elements[$k0]]]:false,
											'logic' 			=> isset($builder[$_prefix.'logic'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'logic'][$_counter[$_elements[$k0]]]:""

										);									
										break;

									case "divider":
										$global_epos[$priority][$tmcp_id]['sections'][$_s]['elements'][]=array(
											'type'				=> $_new_type,
											'size'				=> $_div_size[$k0],
											'required'			=> "",
											'use_images' 		=> "",
											'items_per_row' 	=> "",
											'label_size'		=> "",
											'label'				=> "",
											'label_color'		=> "",
											'description'		=> "",
											'description_color'	=> "",
											'divider_type'		=> isset( $builder[$_prefix.'divider_type'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'divider_type'][$_counter[$_elements[$k0]]]:"",
											'placeholder'		=> "",
											'max_chars'			=> "",
											'hide_amount'		=> "",
											"options"			=> $_options,
											'rules'				=> $_rules,
											'price_rules'		=> $_regular_price,
											'price_rules_type'	=> $_regular_price_type,
											'rules_type'		=> $_rules_type,
											'images'			=> "",
											'limit'				=> "",
											'option_values'		=> array(),
											'button_type'=>'',
											'uniqid' 			=> isset($builder[$_prefix.'uniqid'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'uniqid'][$_counter[$_elements[$k0]]]:uniqid('', true) ,
											'clogic' 			=> isset($builder[$_prefix.'clogic'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'clogic'][$_counter[$_elements[$k0]]]:false,
											'logic' 			=> isset($builder[$_prefix.'logic'][$_counter[$_elements[$k0]]])?$builder[$_prefix.'logic'][$_counter[$_elements[$k0]]]:""

										);									
										break;

									}
								}
							}

							$_helper_counter=intval( $_helper_counter+intval( $_sections[$_s] ) );

						}
					}
				}
			}
		}

		ksort( $global_epos );

		if ( $tmlocalprices ) {

			$attributes=maybe_unserialize( get_post_meta( $post_id, '_product_attributes', true ) );

			foreach ( $tmlocalprices as $price ) {
				$tmcp_id           								= absint( $price->ID );
				$tmcp_required          						= get_post_meta( $tmcp_id, 'tmcp_required', true );
				$tmcp_hide_price          						= get_post_meta( $tmcp_id, 'tmcp_hide_price', true );
				$tmcp_limit          							= get_post_meta( $tmcp_id, 'tmcp_limit', true );
				$product_epos[$tmcp_id]['is_form']  	= 0;
				$product_epos[$tmcp_id]['required']  	= empty( $tmcp_required )?0:1;
				$product_epos[$tmcp_id]['hide_price']  = empty( $tmcp_hide_price )?0:1;
				$product_epos[$tmcp_id]['limit']  		= empty( $tmcp_limit )?"":$tmcp_limit;
				$product_epos[$tmcp_id]['name']   		= get_post_meta( $tmcp_id, 'tmcp_attribute', true );
				$product_epos[$tmcp_id]['is_taxonomy'] = get_post_meta( $tmcp_id, 'tmcp_attribute_is_taxonomy', true );
				$product_epos[$tmcp_id]['label']   	= wc_attribute_label( $product_epos[$tmcp_id]['name'] );
				$product_epos[$tmcp_id]['type']   		= get_post_meta( $tmcp_id, 'tmcp_type', true );

				// Retrieve attributes
				$product_epos[$tmcp_id]['attributes']  = array();
				if ( $product_epos[$tmcp_id]['is_taxonomy'] ) {
					if ( !( $attributes[$product_epos[$tmcp_id]['name']]['is_variation'] ) ) {
						$all_terms = get_terms( $attributes[$product_epos[$tmcp_id]['name']]['name'] , 'orderby=name&hide_empty=0' );
						if ( $all_terms ) {
			                foreach ( $all_terms as $term ) {
			                    $has_term = has_term( (int) $term->term_id, $attributes[$product_epos[$tmcp_id]['name']]['name'], $post_id ) ? 1 : 0;
			                    if ($has_term ){			                        
			                        $product_epos[$tmcp_id]['attributes'][esc_attr( $term->slug )]=apply_filters( 'woocommerce_tm_epo_option_name', esc_html( $term->name ) ) ;
			                    }
			                }
			            }
						
					}
				}else {
					if ( isset( $attributes[$product_epos[$tmcp_id]['name']] ) ) {
						$options = array_map( 'trim', explode( WC_DELIMITER, $attributes[$product_epos[$tmcp_id]['name']]['value'] ) );
						foreach ( $options as $option ) {
							$product_epos[$tmcp_id]['attributes'][esc_attr( sanitize_title( $option ) )]=esc_html( apply_filters( 'woocommerce_tm_epo_option_name', $option ) ) ;
						}
					}
				}

				// Retrieve price rules
				$_regular_price=get_post_meta( $tmcp_id, '_regular_price', true );
				$_regular_price_type=get_post_meta( $tmcp_id, '_regular_price_type', true );
				$product_epos[$tmcp_id]['rules']=$_regular_price;
				$product_epos[$tmcp_id]['rules_type']=$_regular_price_type;
				if ( !is_array( $_regular_price ) ) {
					$_regular_price=array();
				}
				if ( !is_array( $_regular_price_type ) ) {
					$_regular_price_type=array();
				}
				foreach ( $_regular_price as $key=>$value ) {
					foreach ( $value as $k=>$v ) {
						$_regular_price[$key][$k]=wc_format_localized_price( $v );
					}
				}
				foreach ( $_regular_price_type as $key=>$value ) {
					foreach ( $value as $k=>$v ) {
						$_regular_price_type[$key][$k]= $v ;
					}
				}
				$product_epos[$tmcp_id]['price_rules']=$_regular_price;
				$product_epos[$tmcp_id]['price_rules_type']=$_regular_price_type;
			}
		}

		return array(
			'global'=> $global_epos,
			'local' => $product_epos
		);
	}

	/**
	 * Filters an $input array by key.
	 */
	private function array_filter_key( $input ,$what="tmcp_",$where="start") {
		if ( !is_array( $input ) || empty( $input ) ) {
			return array();
		}

		$filtered_result=array();

		if ($where=="end"){
			$what=strrev($what);
		}

		foreach ( $input as $key => $value ) {
			$k=$key;
			if ($where=="end"){
				$k=strrev($key);
			}
			if ( strpos( $k, $what ) === 0 ) {
				$filtered_result[$key] = $value;
			}
		}

		return $filtered_result;
	}

	/**
	 * Translate $attributes to post names.
	 */
	private function translate_fields( $attributes, $type, $section, $form_prefix="" ) {
		$fields=array();
		$loop=0;

		/* $form_prefix should be passed with _ if not empty */
		if ( !empty( $attributes ) ) {

			foreach ( $attributes as $key=>$attribute ) {
				$name_inc="";
				switch ( $type ) {
				case "radio":
					$name_inc ="tmcp_radio_".$section.$form_prefix;
					break;
				case "select":
					$name_inc ="tmcp_select_".$section.$form_prefix;
					break;
				case "checkbox":
					$name_inc ="tmcp_checkbox_".$section."_".$loop.$form_prefix;
					break;
				}
				$fields[]=$name_inc;
				$loop++;
			}

		}else {

			switch ( $type ) {
			case "upload":
				$name_inc ="tmcp_upload_".$section.$form_prefix;
				break;	
			case "textarea":
				$name_inc ="tmcp_textarea_".$section.$form_prefix;
				break;
			case "textfield":
				$name_inc ="tmcp_textfield_".$section.$form_prefix;
				break;
			case "select":
				$name_inc ="tmcp_select_".$section.$form_prefix;
				break;
			}
			if (!empty($name_inc)){
				$fields[]=$name_inc;
			}

		}

		return $fields;
	}

	/**
	 * Adds an item to the cart.
	 */
	public function add_cart_item( $cart_item ) {

		if ( ! empty( $cart_item['tmcartepo'] ) ) {
			$tmcp_prices = 0;
			foreach ( $cart_item['tmcartepo'] as $tmcp ) {
				$tmcp['price']=(float)$tmcp['price'];
				$tmcp_prices += $tmcp['price'];				
			}
			$cart_item['data']->adjust_price( $tmcp_prices );
		}

		/**
		 * variation slug-to-name-for order again
		 */
		if ( isset( $cart_item["variation"] ) && is_array( $cart_item["variation"] ) ) {
			$_variation_name_fix=array();
			$_temp=array();
			foreach ( $cart_item["variation"] as $meta_name => $meta_value ) {
				if ( strpos( $meta_name, "attribute_" )!==0 ) {
					$_variation_name_fix["attribute_".$meta_name]=$meta_value;
					$_temp[$meta_name]=$meta_value;
				}
			}
			$cart_item["variation"]=array_diff_key( $cart_item["variation"], $_temp );
			$cart_item["variation"]=array_merge( $cart_item["variation"], $_variation_name_fix );
		}


		return $cart_item;
	}

	/**
	 * Gets the cart from session.
	 */
	public function get_cart_item_from_session( $cart_item, $values ) {
		if ( ! empty( $values['tmcartepo'] ) ) {
			$cart_item['tmcartepo'] = $values['tmcartepo'];
			$cart_item = $this->add_cart_item( $cart_item );
		}
		if ( ! empty( $values['tmcartepo_bto'] ) ) {
			$cart_item['tmcartepo_bto'] = $values['tmcartepo_bto'];
		}
		return $cart_item;
	}

	/**
	 * Filters our cart items.
	 */
	private function filtered_get_item_data( $cart_item ) {
		$filtered_array=array();

		foreach ( $cart_item['tmcartepo'] as $tmcp ) {

			if ( !isset( $filtered_array[$tmcp['section']] ) ) {
				$filtered_array[$tmcp['section']]=array(
					'label' 		=> $tmcp['section_label'],
					'other_data' 	=> array( 
						array(
							'name'    	=> $tmcp['name'],
							'value'   	=> $tmcp['value'],
							'display' 	=> isset( $tmcp['display'] ) ? $tmcp['display'] : '',
							'images' 	=> isset( $tmcp['images'] ) ? $tmcp['images'] : ''
						) ),
					'price' 		=> $tmcp['price'],
					'percentcurrenttotal' => isset($tmcp['percentcurrenttotal'])?$tmcp['percentcurrenttotal']:0
				);
			}else {
				$filtered_array[$tmcp['section']]['price'] +=$tmcp['price'];
				$filtered_array[$tmcp['section']]['other_data'][] =  array(
					'name'    	=> $tmcp['name'],
					'value'   	=> $tmcp['value'],
					'display' 	=> isset( $tmcp['display'] ) ? $tmcp['display'] : '',
					'images' 	=> isset( $tmcp['images'] ) ? $tmcp['images'] : ''
				);
			}
		}

		return $filtered_array;
	}

	private function get_price_for_cart($price=0){
		$symbol="+";
		if (floatval($price)<0){
			$symbol="-";
		}
		if (floatval($price)==0){
			$symbol="";
		}else{
			$symbol=" ($symbol" .(woocommerce_price(abs($price) )).")";
		}
		return $symbol;
	}

	/**
	 * Gets cart item to display in the frontend.
	 */
	public function get_item_data( $other_data, $cart_item ) {

		if ( ! empty( $cart_item['tmcartepo'] ) ) {

			$filtered_array=$this->filtered_get_item_data( $cart_item );
			$price=0;
			$link_data=array();
			foreach ( $filtered_array as $section ) {

				$value=array();

				foreach ( $section['other_data'] as $key=>$data ) {
					$display_value = ! empty( $data['display'] ) ? $data['display'] : $data['value'];

					if (!empty($data['images'])){
						$display_value ='<div class="cpf-img-on-cart"><img alt="" class="attachment-shop_thumbnail wp-post-image epo-option-image" src="'.$data['images'].'" /></div>'.$display_value;
					}
					$value[]=$display_value;
				}

				if ( !empty( $value ) && count( $value )>0 ) {
					$value=implode( " , ", $value );
				}else {
					$value="";
				}				

				$price=$price+$section['price'];
				$format_price=$this->get_price_for_cart($section['price']);
				$other_data[] = array(
					'name'    => $section['label'] . $format_price,
					'value'   => $value
				);
				$link_data[] = array(
					'name'    => $section['label'] ,
					'value'   => $value,
					'price'   => $format_price
				);
			}

			if ($this->tm_epo_cart_field_display=="link"){
				if (empty($price)){
					$price='';
				}else{
					$price=$this->get_price_for_cart($price);
				}
				$uni=uniqid('');
				$data='<div class="tm-extra-product-options">';
				foreach ( $link_data as $link ) {
					$data .= '<div class="row tm-cart-row">'
							. '<div class="cell col-5 cpf-name">'.$link['name'].'</div>'
							. '<div class="cell col-4 cpf-value">'.$link['value'].'</div>'
							. '<div class="cell col-3 cpf-price">'.$link['price'].'</div>'
							. '</div>';

				}

				$other_data=array(
					array(
						'name' 	=> '<a href="#tm-cart-link-data-'.$uni.'" class="tm-cart-link">'.__( 'Additional options', TM_EPO_TRANSLATION ).'</a>',
						'value' => $price.'<div id="tm-cart-link-data-'.$uni.'" class="tm-cart-link-data tm-hidden">'.$data.'</div>'
						)
					);
			}

		}	
		
		return $other_data;
	}

	private function calculate_price( $element, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id ) {
		$_price=0;
		$_price_type="";
		if ($per_product_pricing){

			if ( !isset( $element['price_rules'][$key] ) ) {// field price rule
				if ( $variation_id && isset( $element['price_rules'][0][$variation_id] ) ) {// general variation rule
					$_price=$element['price_rules'][0][$variation_id];
				}elseif ( isset( $element['price_rules'][0][0] ) ) {// general rule
					$_price=$element['price_rules'][0][0];
				}
			}else {
				if ( $variation_id && isset( $element['price_rules'][$key][$variation_id] ) ) {// field price rule
					$_price=$element['price_rules'][$key][$variation_id];
				}elseif ( isset( $element['price_rules'][$key][0] ) ) {// general field variation rule
					$_price=$element['price_rules'][$key][0];
				}elseif ( $variation_id && isset( $element['price_rules'][0][$variation_id] ) ) {// general variation rule
					$_price=$element['price_rules'][0][$variation_id];
				}elseif ( isset( $element['price_rules'][0][0] ) ) {// general rule
					$_price=$element['price_rules'][0][0];
				}
			}

			if ( !isset( $element['price_rules_type'][$key] ) ) {// field price rule
				if ( $variation_id && isset( $element['price_rules_type'][0][$variation_id] ) ) {// general variation rule
					$_price_type=$element['price_rules_type'][0][$variation_id];
				}elseif ( isset( $element['price_rules_type'][0][0] ) ) {// general rule
					$_price_type=$element['price_rules_type'][0][0];
				}
			}else {
				if ( $variation_id && isset( $element['price_rules_type'][$key][$variation_id] ) ) {// field price rule
					$_price_type=$element['price_rules_type'][$key][$variation_id];
				}elseif ( isset( $element['price_rules_type'][$key][0] ) ) {// general field variation rule
					$_price_type=$element['price_rules_type'][$key][0];
				}elseif ( $variation_id && isset( $element['price_rules_type'][0][$variation_id] ) ) {// general variation rule
					$_price_type=$element['price_rules_type'][0][$variation_id];
				}elseif ( isset( $element['price_rules_type'][0][0] ) ) {// general rule
					$_price_type=$element['price_rules_type'][0][0];
				}
			}
			
			if ($_price_type=="percent"){
				if ($cpf_product_price){
					$_price=($_price/100)*floatval($cpf_product_price);
				}
			}
			if ($_price_type=="percentcurrenttotal"){
				if (isset($_POST[$attribute.'_hidden'])){
					$_price=floatval($_POST[$attribute.'_hidden']);
				}
			}

		}
		return $_price;
	}

	/**
	 * Adds data to the cart.
	 */
	public function add_cart_item_data( $cart_item_meta, $product_id ) {

		/* Workaround to get unique items in cart for bto */
		$terms 			= get_the_terms( $product_id, 'product_type' );
		$product_type 	= ! empty( $terms ) && isset( current( $terms )->name ) ? sanitize_title( current( $terms )->name ) : 'simple';
		if ( $product_type == 'bto' && isset( $_REQUEST[ 'add-product-to-cart' ] ) && is_array( $_REQUEST[ 'add-product-to-cart' ] ) ) {
			$copy=array();
			foreach ( $_REQUEST[ 'add-product-to-cart' ] as $bundled_item_id => $bundled_product_id ) {
				$copy=array_merge($copy,$this->array_filter_key( $_POST ,$bundled_item_id,"end"));				
			}
			$copy=$this->array_filter_key( $copy);
			$cart_item_meta['tmcartepo_bto']=$copy;
		}

		$form_prefix="";
		$variation_id=false;
		$cpf_product_price=false;
		$per_product_pricing=true;

		if (isset($cart_item_meta['composite_item'])){
			global $woocommerce;
			$cart_contents = $woocommerce->cart->get_cart();

			if ( isset( $cart_item_meta[ 'composite_parent' ] ) && ! empty( $cart_item_meta[ 'composite_parent' ] ) ) {
				$parent_cart_key = $cart_item_meta[ 'composite_parent' ];
				$per_product_pricing 	= $cart_contents[ $parent_cart_key ][ 'data' ]->per_product_pricing;
				if ( $per_product_pricing == 'no' ) {
					$per_product_pricing=false;
				}
			}
			
			$form_prefix="_".$cart_item_meta['composite_item'];
			$bundled_item_id= $cart_item_meta['composite_item'];
			if (isset($_REQUEST[ 'bto_variation_id' ][ $bundled_item_id ])){
				$variation_id=$_REQUEST[ 'bto_variation_id' ][ $bundled_item_id ];
			}
			if (isset($_POST['cpf_product_price'.$form_prefix])){
				$cpf_product_price=$_POST['cpf_product_price'.$form_prefix];
			}
		}else{
			if (isset($_POST['variation_id'])){
				$variation_id=$_POST['variation_id'];
			}
			if (isset($_POST['cpf_product_price'])){
				$cpf_product_price=$_POST['cpf_product_price'];
			}		
		}

		$cpf_price_array  = $this->get_product_tm_epos( $product_id );
		$global_price_array = $cpf_price_array['global'];
		$local_price_array  = $cpf_price_array['local'];

		$global_prices=array( 'before'=>array(), 'after'=>array() );
		foreach ( $global_price_array as $priority=>$priorities ) {
			foreach ( $priorities as $pid=>$field ) {
				foreach ( $field['sections'] as $section_id=>$section ) {
					if ( isset( $section['sections_placement'] ) ) {
						$global_prices[$section['sections_placement']][$priority][$pid]['sections'][$section_id]=$section;
					}
				}
			}
		}

		$files=array();
		foreach ( $_FILES as $k=>$file){
			if (!empty($file['name'])){
				$files[$k]=$file['name'];
			}

		}

		$tmcp_post_fields = array_merge($this->array_filter_key( $_POST ),$this->array_filter_key( $files ));
		if ( is_array( $tmcp_post_fields ) ) {
			$tmcp_post_fields = array_map( 'stripslashes_deep', $tmcp_post_fields );
		}

		if ( empty( $cart_item_meta['tmcartepo'] ) ) {
			$cart_item_meta['tmcartepo'] = array();
		}

		$loop=0;
		$field_loop=0;

		foreach ( $global_prices['before'] as $priorities ) {
			foreach ( $priorities as $field ) {
				foreach ( $field['sections'] as $section_id=>$section ) {
					if ( isset( $section['elements'] ) ) {
						foreach ( $section['elements'] as $element ) {

							$current_tmcp_post_fields=array_intersect_key(  $tmcp_post_fields , array_flip( $this->translate_fields( $element['options'], $element['type'], $field_loop, $form_prefix ) )  );

							foreach ( $current_tmcp_post_fields as $attribute=>$key ) {
								
								switch ( $element['type'] ) {
								
								case "upload" :
									$_price=$this->calculate_price( $element, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id );
									if (empty($key)){
										$_price=0;
									}
									if ( ! empty( $_FILES[ $attribute ] ) && ! empty( $_FILES[ $attribute ]['name'] ) ) {
										$upload = $this->upload_file( $_FILES[ $attribute ] );
										
										if ( empty( $upload['error'] ) && ! empty( $upload['file'] ) ) {
											$value  = woocommerce_clean( $upload['url'] );
											
											$cart_item_meta['tmcartepo'][] = array(
												'name'   => esc_html( $element['label'] ),
												'value'  => esc_html( $value ),
												'display'	=> esc_html(basename( $value )),
												'price'  => esc_attr( $_price ),
												'section'  => esc_html( $element['label'] ),
												'section_label'  => esc_html( $element['label'] ),
												'percentcurrenttotal' => isset($_POST[$attribute.'_hidden'])?1:0
											);
										}else{											
											wc_add_notice( $upload['error'] , 'error' );
										}
									}

									break;

								case "checkbox" :
								case "radio" :
								case "select" :
									$_price=$this->calculate_price( $element, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id );
									$_image_key= array_search($key, $element['option_values']);
									if ($_image_key===NULL || $_image_key===FALSE){
										$_image_key=FALSE;
									}
									$cart_item_meta['tmcartepo'][] = array(
										'name'   		=> esc_html( $element['label'] ),
										'value'  		=> esc_html( $element['options'][$key] ),
										'price'  		=> esc_attr( $_price ),
										'section' 		=> esc_html( $element['label'] ),
										'section_label' => esc_html( $element['label'] ),
										'percentcurrenttotal' => isset($_POST[$attribute.'_hidden'])?1:0,
										'use_images' 	=> !empty($element['use_images'])?$element['use_images']:"",
										'images' 		=> ($_image_key!==FALSE && isset($element['images'][$_image_key]))?$element['images'][$_image_key]:""
									);
									break;

								case "textarea" :
								case "textfield" :									
									if (!empty($key)){
										
										$_price=$this->calculate_price( $element, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id );
									 
										$cart_item_meta['tmcartepo'][] = array(
											'name' 			=> esc_html( $element['label'] ),
											'value' 		=> esc_html( $key ),
											'price' 		=> esc_attr( $_price ),
											'section' 		=> esc_html( $element['label'] ),
											'section_label' => esc_html( $element['label'] ),
											'percentcurrenttotal' => isset($_POST[$attribute.'_hidden'])?1:0
										);
									}
									break;

								}
							}

							if (in_array($element['type'], $this->element_post_types)   ){
								$field_loop++;
							}
							$loop++;

						}
					}
				}
			}
		}

		if ( ! empty( $local_price_array ) && is_array( $local_price_array ) && count( $local_price_array ) > 0 ) {

			if ( is_array( $tmcp_post_fields ) ) {

				foreach ( $local_price_array as $tmcp ) {
					if ( empty( $tmcp['type'] ) ) {
						continue;
					}

					$current_tmcp_post_fields=array_intersect_key(  $tmcp_post_fields , array_flip( $this->translate_fields( $tmcp['attributes'], $tmcp['type'], $field_loop, $form_prefix ) ) );

					foreach ( $current_tmcp_post_fields as $attribute=>$key ) {
						
						switch ( $tmcp['type'] ) {

						case "checkbox" :
						case "radio" :
						case "select" :
							$_price=$this->calculate_price( $tmcp, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id );
							
							$cart_item_meta['tmcartepo'][] = array(
								'name'   => esc_html( $tmcp['name'] ),
								'value'  => esc_html( $tmcp['attributes'][$key]  ),
								'price'  => esc_attr( $_price ),
								'section'  => esc_html( $tmcp['name'] ),
								'section_label'  => esc_html( $tmcp['label'] ),
								'percentcurrenttotal' => isset($_POST[$attribute.'_hidden'])?1:0
							);
							break;

						}
					}
					if (in_array($tmcp['type'], $this->element_post_types)   ){
						$field_loop++;
					}
					$loop++;

				}
			}
		}

		foreach ( $global_prices['after'] as $priorities ) {
			foreach ( $priorities as $field ) {
				foreach ( $field['sections'] as $section_id=>$section ) {
					if ( isset( $section['elements'] ) ) {
						foreach ( $section['elements'] as $element ) {

							$current_tmcp_post_fields=array_intersect_key(  $tmcp_post_fields , 
								array_flip( $this->translate_fields( $element['options'], $element['type'], $field_loop, $form_prefix ) )  );

							foreach ( $current_tmcp_post_fields as $attribute=>$key ) {
								
								switch ( $element['type'] ) {

								case "upload" :
									$_price=$this->calculate_price( $element, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id );
									if (empty($key)){
										$_price=0;
									}
									if ( ! empty( $_FILES[ $attribute ] ) && ! empty( $_FILES[ $attribute ]['name'] ) ) {
										$upload = $this->upload_file( $_FILES[ $attribute ] );
										
										if ( empty( $upload['error'] ) && ! empty( $upload['file'] ) ) {
											$value  = woocommerce_clean( $upload['url'] );
											
											$cart_item_meta['tmcartepo'][] = array(
												'name'   => esc_html( $element['label'] ),
												'value'  => esc_html( $value ),
												'display'	=> esc_html(basename( $value )),
												'price'  => esc_attr( $_price ),
												'section'  => esc_html( $element['label'] ),
												'section_label'  => esc_html( $element['label'] ),
												'percentcurrenttotal' => isset($_POST[$attribute.'_hidden'])?1:0
											);
										}else{											
											wc_add_notice( $upload['error'] , 'error' );
										}
									}

									break;

								case "checkbox" :
								case "radio" :
								case "select" :
									$_price=$this->calculate_price( $element, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id );
									$_image_key= array_search($key, $element['option_values']);
									if ($_image_key===NULL || $_image_key===FALSE){
										$_image_key=FALSE;
									}
									$cart_item_meta['tmcartepo'][] = array(
										'name'   		=> esc_html( $element['label'] ),
										'value'  		=> esc_html( $element['options'][$key] ),
										'price'  		=> esc_attr( $_price ),
										'section' 		=> esc_html( $element['label'] ),
										'section_label' => esc_html( $element['label'] ),
										'percentcurrenttotal' => isset($_POST[$attribute.'_hidden'])?1:0,
										'use_images' 	=> !empty($element['use_images'])?$element['use_images']:"",
										'images' 		=> ($_image_key!==FALSE && isset($element['images'][$_image_key]))?$element['images'][$_image_key]:""
									);
									break;

								case "textarea" :
								case "textfield" :									
									if (!empty($key)){
										
										$_price=$this->calculate_price( $element, $key, $attribute, $per_product_pricing, $cpf_product_price, $variation_id );
									 
										$cart_item_meta['tmcartepo'][] = array(
											'name' 			=> esc_html( $element['label'] ),
											'value' 		=> esc_html( $key ),
											'price' 		=> esc_attr( $_price ),
											'section' 		=> esc_html( $element['label'] ),
											'section_label' => esc_html( $element['label'] ),
											'percentcurrenttotal' => isset($_POST[$attribute.'_hidden'])?1:0
										);
									}
									break;

								}
							}

							if (in_array($element['type'], $this->element_post_types)   ){
								$field_loop++;
							}
							$loop++;

						}
					}
				}
			}
		}	

		return $cart_item_meta;
	}

	/**
	 * Adds meta data to the order.
	 */
	public function order_item_meta( $item_id, $values ) {
		if ( ! empty( $values['tmcartepo'] ) ) {			
			woocommerce_add_order_item_meta( $item_id, '_tmcartepo_data', $values['tmcartepo'] );
			$filtered_array=$this->filtered_get_item_data( $values );
			foreach ( $filtered_array as $section ) {
				$value=array();
				foreach ( $section['other_data'] as $key=>$data ) {
					$display_value = ! empty( $data['display'] ) ? $data['display'] : $data['value'];
					if (!empty($data['images'])){
						$display_value ='<div><img alt="" class="attachment-shop_thumbnail wp-post-image epo-option-image" src="'.$data['images'].'" /></div>'.$display_value;
					}else{
						$display_value = $data['value'];
					}
					$value[]=$display_value;
				}
				if ( !empty( $value ) && count( $value )>0 ) {
					$value=implode( " , ", $value );
				}else {
					$value="";
				}				

				$name = $section['label'] . $this->get_price_for_cart($section['price']);
				woocommerce_add_order_item_meta( $item_id, $name, $value );
			}
		}
	}

	/**
	 * Validates the cart data.
	 */

	public function add_to_cart_validation( $passed, $product_id, $qty, $variation_id = '', $variations = array(), $cart_item_data = array() ) {

		$is_validate=true;

		// Get product type
		$terms 			= get_the_terms( $product_id, 'product_type' );
		$product_type 	= ! empty( $terms ) && isset( current( $terms )->name ) ? sanitize_title( current( $terms )->name ) : 'simple';
		if ( $product_type == 'bto' ) {

			$bto_data 	= maybe_unserialize( get_post_meta( $product_id, '_bto_data', true ) );
			$valid_ids 	= array_keys( $bto_data );

			foreach ( $valid_ids as $bundled_item_id ) {

				if ( isset( $_REQUEST[ 'add-product-to-cart' ][ $bundled_item_id ] ) && $_REQUEST[ 'add-product-to-cart' ][ $bundled_item_id ] !== '' ) {
					$bundled_product_id = $_REQUEST[ 'add-product-to-cart' ][ $bundled_item_id ];
				} elseif ( isset( $cart_item_data[ 'composite_data' ][ $bundled_item_id ][ 'product_id' ] ) && isset( $_GET[ 'order_again' ] ) ) {
					$bundled_product_id = $cart_item_data[ 'composite_data' ][ $bundled_item_id ][ 'product_id' ];
				}

				if (isset($bundled_product_id) && !empty($bundled_product_id)){

					$_passed=true;

					if ( isset( $_REQUEST[ 'item_quantity' ][ $bundled_item_id ] ) && is_numeric( $_REQUEST[ 'item_quantity' ][ $bundled_item_id ] ) ) {
						$item_quantity = absint( $_REQUEST[ 'item_quantity' ][ $bundled_item_id ] );
					} elseif ( isset( $cart_item_data[ 'composite_data' ][ $bundled_item_id ][ 'quantity' ] ) && isset( $_GET[ 'order_again' ] ) ) {
						$item_quantity = $cart_item_data[ 'composite_data' ][ $bundled_item_id ][ 'quantity' ];
					}
					if ( !empty($item_quantity)){
						$item_quantity = absint( $item_quantity );
						
						$_passed = $this->validate_product_id( $bundled_item_id, $item_quantity, $bundled_item_id );
						
					}

					if (!$_passed){
						$is_validate=false;
					}
					
				}
			}
		}

		$passed = $this->validate_product_id( $product_id, $qty );

		/* Try to validate uploads before they happen */
		$files=array();
		foreach ( $_FILES as $k=>$file){
			if (!empty($file['name'])){
				if(!empty($file['error'])){
					$passed=false;
					// Courtesy of php.net, the strings that describe the error indicated in $_FILES[{form field}]['error'].
					$upload_error_strings = array( false,
						__( "The uploaded file exceeds the upload_max_filesize directive in php.ini.", TM_EPO_TRANSLATION  ),
						__( "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.", TM_EPO_TRANSLATION  ),
						__( "The uploaded file was only partially uploaded.", TM_EPO_TRANSLATION  ),
						__( "No file was uploaded.", TM_EPO_TRANSLATION  ),
						'',
						__( "Missing a temporary folder.", TM_EPO_TRANSLATION  ),
						__( "Failed to write file to disk.", TM_EPO_TRANSLATION  ),
						__( "File upload stopped by extension.", TM_EPO_TRANSLATION  ));
					if (isset($upload_error_strings[$file['error']])){
						wc_add_notice( $upload_error_strings[$file['error']] , 'error' );
					}
				}
				$check_filetype=wp_check_filetype( $file['name'] ) ;
				$check_filetype=$check_filetype['ext'];
				if (!$check_filetype){
					$passed=false;
					wc_add_notice( __( "Sorry, this file type is not permitted for security reasons.", TM_EPO_TRANSLATION  ) , 'error' );
				}
			}			

		}

		if (!$is_validate){
			$passed=false;
		}		

		return $passed;

	}

	public function validate_product_id( $product_id, $qty, $form_prefix="" ) {

		$passed=true;
		if ($form_prefix){
			$form_prefix="_".$form_prefix;
		}

		$cpf_price_array  = $this->get_product_tm_epos( $product_id );
		$global_price_array = $cpf_price_array['global'];
		$local_price_array  = $cpf_price_array['local'];

		$global_prices=array( 'before'=>array(), 'after'=>array() );
		foreach ( $global_price_array as $priority=>$priorities ) {
			foreach ( $priorities as $pid=>$field ) {
				if (isset($field['sections'])){
					foreach ( $field['sections'] as $section_id=>$section ) {
						if ( isset( $section['sections_placement'] ) ) {
							$global_prices[$section['sections_placement']][$priority][$pid]['sections'][$section_id]=$section;
						}
					}
				}
			}
		}

		if ( ( ! empty( $global_price_array ) && is_array( $global_price_array ) && count( $global_price_array ) > 0 ) || ( ! empty( $local_price_array ) && is_array( $local_price_array ) && count( $local_price_array ) > 0 ) ) {
			$tmcp_post_fields = $this->array_filter_key( $_POST);
			if ( is_array( $tmcp_post_fields ) && !empty( $tmcp_post_fields ) && count( $tmcp_post_fields )>0  ) {
				$tmcp_post_fields = array_map( 'stripslashes', $tmcp_post_fields );
			}
		}

		$loop=-1;

		foreach ( $global_prices['before'] as $priorities ) {
			foreach ( $priorities as $field ) {
				foreach ( $field['sections'] as $section_id=>$section ) {
					if ( isset( $section['elements'] ) ) {
						foreach ( $section['elements'] as $element ) {
							
							if (in_array($element['type'], $this->element_post_types)   ){
								$loop++;
							}
							
							if ( $element['required'] ) {

								$tmcp_attributes=$this->translate_fields( $element['options'], $element['type'], $loop, $form_prefix );
								$_passed = true;
								switch ( $element['type'] ) {

								case "upload" :									
									foreach ( $tmcp_attributes as $attribute ) {
										if ( empty( $_FILES[ $attribute ] ) || empty( $_FILES[ $attribute ]['name'] ) ) {
											$_passed = false;
										}										
									}
									break;

								case "checkbox" :
									$_check=array_intersect( $tmcp_attributes, array_keys( $tmcp_post_fields ) );

									if ( empty( $_check ) || count( $_check )==0 ) {
										$_passed = false;
									}
									break;

								case "radio" :
									foreach ( $tmcp_attributes as $attribute ) {
										if ( !isset( $tmcp_post_fields[$attribute] ) ) {
											$_passed = false;
										}
									}
									break;

								case "select" :
								case "textarea" :
								case "textfield" :
									foreach ( $tmcp_attributes as $attribute ) {
										if ( !isset( $tmcp_post_fields[$attribute] ) ||  $tmcp_post_fields[$attribute]=="" ) {
											$_passed = false;
										}
									}
									break;

								}

								if ( ! $_passed ) {
									$passed = false;
									wc_add_notice( sprintf( __( '"%s" is a required field.', 'woocommerce' ), $element['label'] ) , 'error' );
									
								}
							}
						}
					}
				}
			}
		}



		if ( ! empty( $local_price_array ) && is_array( $local_price_array ) && count( $local_price_array ) > 0 ) {

			foreach ( $local_price_array as $tmcp ) {

				if (in_array($tmcp['type'], $this->element_post_types)   ){
					$loop++;
				}
				if ( empty( $tmcp['type'] ) || empty( $tmcp['required'] ) ) {
					continue;
				}

				if ( $tmcp['required'] ) {

					$tmcp_attributes=$this->translate_fields( $tmcp['attributes'], $tmcp['type'], $loop, $form_prefix );
					$_passed=true;

					switch ( $tmcp['type'] ) {

					case "checkbox" :
						$_check=array_intersect( $tmcp_attributes, array_keys( $tmcp_post_fields ) );
						if ( empty( $_check ) || count( $_check )==0 ) {
							$_passed = false;
						}
						break;

					case "radio" :
						foreach ( $tmcp_attributes as $attribute ) {
							if ( !isset( $tmcp_post_fields[$attribute] ) ) {
								$_passed = false;
							}
						}
						break;

					case "select" :
						foreach ( $tmcp_attributes as $attribute ) {
							if ( !isset( $tmcp_post_fields[$attribute] ) ||  $tmcp_post_fields[$attribute]=="" ) {
								$_passed = false;
							}
						}
						break;

					}

					if ( ! $_passed ) {
						$passed=false;
						wc_add_notice( sprintf( __( '"%s" is a required field.', 'woocommerce' ), $tmcp['label'] ) , 'error' );
						
					}
				}
			}

		}

		foreach ( $global_prices['after'] as $priorities ) {
			foreach ( $priorities as $field ) {
				foreach ( $field['sections'] as $section_id=>$section ) {
					if ( isset( $section['elements'] ) ) {
						foreach ( $section['elements'] as $element ) {

							if (in_array($element['type'], $this->element_post_types)   ){
								$loop++;
							}
							
							if ( $element['required'] ) {
								$tmcp_attributes=$this->translate_fields( $element['options'], $element['type'], $loop, $form_prefix );
								$_passed = true;

								switch ( $element['type'] ) {

								case "upload" :									
									foreach ( $tmcp_attributes as $attribute ) {
										if ( empty( $_FILES[ $attribute ] ) || empty( $_FILES[ $attribute ]['name'] ) ) {
											$_passed = false;
										}										
									}
									break;

								case "checkbox" :
									$_check=array_intersect( $tmcp_attributes, array_keys( $tmcp_post_fields ) );
									if ( empty( $_check ) || count( $_check )==0 ) {
										$_passed = false;
									}
									break;

								case "radio" :
									foreach ( $tmcp_attributes as $attribute ) {
										if ( !isset( $tmcp_post_fields[$attribute] ) ) {
											$_passed = false;
										}
									}
									break;

								case "select" :
								case "textarea" :
								case "textfield" :
									foreach ( $tmcp_attributes as $attribute ) {
										if ( !isset( $tmcp_post_fields[$attribute] ) ||  $tmcp_post_fields[$attribute]=="" ) {
											$_passed = false;
										}
									}
									break;

								}

								if ( ! $_passed ) {
									$passed = false;
									wc_add_notice( sprintf( __( '"%s" is a required field.', 'woocommerce' ), $element['label'] ) , 'error' );
									
								}
							}
						}
					}
				}
			}
		}


		return $passed;
	}

	/**
	 * Gets the stored card data for the order again functionality.
	 */
	public function order_again_cart_item_data( $cart_item_meta, $product, $order ) {
		global $woocommerce;

		// Disable validation
		remove_filter( 'woocommerce_add_to_cart_validation', array( $this, 'add_to_cart_validation' ), 50, 6 );

		$_backup_cart = isset( $product['item_meta']['tmcartepo_data'] ) ? $product['item_meta']['tmcartepo_data'] : false;
		if ( !$_backup_cart ) {
			$_backup_cart = isset( $product['item_meta']['_tmcartepo_data'] ) ? $product['item_meta']['_tmcartepo_data'] : false;
		}
		if ( $_backup_cart && is_array( $_backup_cart ) && isset( $_backup_cart[0] ) ) {
			$_backup_cart=maybe_unserialize( $_backup_cart[0] );
			$cart_item_meta['tmcartepo'] = $_backup_cart;
		}

		return $cart_item_meta;
	}

	/**
	 * Handles the display of builder sections.
	 */
	public function get_builder_display( $field, $where, $args, $form_prefix="" ) {
		
		/* $form_prefix	shoud be passed with _ if not empty */			
		
		$columns=array(
			"w25"=>array( "col-3", 25 ),
			"w33"=>array( "col-4", 33 ),
			"w50"=>array( "col-6", 50 ),
			"w66"=>array( "col-8", 66 ),
			"w75"=>array( "col-9", 75 ),
			"w100"=>array( "col-12", 100 )
		);

		extract( $args, EXTR_OVERWRITE );

		if ( isset( $field['sections'] ) && is_array( $field['sections'] ) ) {

			$args = array(
				'field_id'  => 'tm-epo-field-'.$unit_counter
			);
			wc_get_template(
				'builder-start.php',
				$args ,
				$this->_namespace,
				$this->template_path
			);

			$_section_totals=0;

			foreach ( $field['sections'] as $section ) {
				if ( !isset( $section['sections_placement'] ) || $section['sections_placement']!=$where ) {
					continue;
				}
				if ( isset( $section['sections_size'] ) && isset( $columns[$section['sections_size']] ) ) {
					$size=$columns[$section['sections_size']][0];
				}else {
					$size="col-12";
				}

				$_section_totals=$_section_totals+$columns[$section['sections_size']][1];
				if ( $_section_totals>100 ) {
					$_section_totals=$columns[$section['sections_size']][1];
					echo '<div class="cpfclear"></div>';
				}

				$divider="";
				if ( isset( $section['divider_type'] ) ) {
					switch ( $section['divider_type'] ) {
					case "hr":
						$divider='<hr>';
						break;
					case "divider":
						$divider='<div class="tm_divider"></div>';
						break;
					case "padding":
						$divider='<div class="tm_padding"></div>';
						break;
					}
				}

				$args = array(
					'column' 			=> $size,
					'style' 			=> $section['sections_style'],
					'uniqid' 			=> $section['sections_uniqid'],
					'logic' 			=> esc_html(json_encode( (array) json_decode($section['sections_clogic']) ) ),
					'haslogic' 			=> $section['sections_logic'],
					'title_size'   		=> !empty( $section['label_size'] )?'h'.$section['label_size']:'h3',
					'title'    			=> !empty( $section['label'] )?esc_html( wc_attribute_label( $section['label'] ) ):"",
					'title_color'   	=> !empty( $section['label_color'] )? $section['label_color'] :"",
					'description'   	=> !empty( $section['description'] )?  $section['description']  :"",
					'description_color' => !empty( $section['description_color'] )? $section['description_color'] :"",
					'divider'    		=> $divider
							
				);
				wc_get_template(
					'builder-section-start.php',
					$args ,
					$this->_namespace,
					$this->template_path
				);

				if ( isset( $section['elements'] ) && is_array( $section['elements'] ) ) {
					$totals=0;
					foreach ( $section['elements'] as $element ) {

						$empty_rules="";
						if ( isset( $element['rules'] ) ) {
							$empty_rules=esc_html( json_encode( ( $element['rules'] ) ) );
						}
						$empty_rules_type="";
						if ( isset( $element['rules_type'] ) ) {
							$empty_rules_type=esc_html( json_encode( ( $element['rules_type'] ) ) );
						}
						if ( isset( $element['size'] ) && isset( $columns[$element['size']] ) ) {
							$size=$columns[$element['size']][0];
						}else {
							$size="col-12";
						}

						$totals=$totals+$columns[$element['size']][1];
						if ( $totals>100 ) {
							$totals=$columns[$element['size']][1];
							echo '<div class="cpfclear"></div>';
						}
						$divider="";
						if ( isset( $element['divider_type'] ) ) {
							switch ( $element['divider_type'] ) {
							case "hr":
								$divider='<hr>';
								break;
							case "divider":
								$divider='<div class="tm_divider"></div>';
								break;
							case "padding":
								$divider='<div class="tm_padding"></div>';
								break;
							}
						}
						$args = array(
							'column'    		=> $size,
							'title_size'   		=> !empty( $element['label_size'] )?'h'.$element['label_size']:'h3',
							'title'    			=> !empty( $element['label'] )?esc_html( wc_attribute_label( $element['label'] ) ):"",
							'title_color'   	=> !empty( $element['label_color'] )? $element['label_color'] :"",
							'description'   	=> !empty( $element['description'] )?  $element['description']  :"",
							'description_color' => !empty( $element['description_color'] )? $element['description_color'] :"",
							'divider'    		=> $divider,
							'required'    		=> esc_html( wc_attribute_label( $element['required'] ) ),
							'type'        		=> $element['type'],
							'use_images'        => $element['use_images'],
							'rules'       		=> $empty_rules,
							'rules_type' 		=> $empty_rules_type,
							'element'			=> $element['type'],
							'class_id'			=> "element_".$element_counter,
							'uniqid' 			=> $element['uniqid'],
							'logic' 			=> esc_html(json_encode( (array) json_decode($element['clogic']) ) ),
							'haslogic' 			=> $element['logic']
						);
						wc_get_template(
							'builder-element-start.php',
							$args ,
							$this->_namespace,
							$this->template_path
						);
						$field_counter=0;
						switch ( $element['type'] ) {
						case "header":
							
							break;
						case "divider":
							
							break;
						case "upload":
							$name_inc ="upload_".$element_counter.$form_prefix;
							$tabindex++;

							$args = array(
								'max_size' 		=> size_format( wp_max_upload_size() ),
								'rules'   		=> isset( $element['rules'] )?esc_html( json_encode( ( $element['rules'] ) ) ):'',
								'rules_type'   	=> isset( $element['rules_type'] )?esc_html( json_encode( ( $element['rules_type'] ) ) ):'',
								'id'    		=> 'tmcp_upload_'.$tabindex.$form_prefix,
								'name'    		=> 'tmcp_'.$name_inc,
								'amount'     	=> '0 '.$_currency,
								'hide_amount'  	=> isset( $element['hide_amount'] )?" ".$element['hide_amount']:"",
								'style' 		=> isset( $element['button_type'] )?$element['button_type']:"",
								'tabindex'  	=> $tabindex
							);
							wc_get_template(
								$element['type'].'.php',
								$args ,
								$this->_namespace,
								$this->template_path
							);
							$element_counter++;
							break;
						case "textarea":
							$name_inc ="textarea_".$element_counter.$form_prefix;
							$tabindex++;

							$args = array(
								'placeholder'  	=> isset( $element['placeholder'] )?esc_attr(  $element['placeholder']  ):'',
								'max_chars'  	=> isset( $element['max_chars'] )?absint( $element['max_chars'] ):'',
								'options'   	=> '',
								'rules'   		=> isset( $element['rules'] )?esc_html( json_encode( ( $element['rules'] ) ) ):'',
								'rules_type'   	=> isset( $element['rules_type'] )?esc_html( json_encode( ( $element['rules_type'] ) ) ):'',
								'id'    		=> 'tmcp_textarea_'.$tabindex.$form_prefix,
								'name'    		=> 'tmcp_'.$name_inc,
								'amount'     	=> '0 '.$_currency,
								'hide_amount'  	=> isset( $element['hide_amount'] )?" ".$element['hide_amount']:"",
								'tabindex'  	=> $tabindex
							);
							wc_get_template(
								$element['type'].'.php',
								$args ,
								$this->_namespace,
								$this->template_path
							);
							$element_counter++;
							break;
						case "textfield":
							$name_inc ="textfield_".$element_counter.$form_prefix;
							$tabindex++;

							$args = array(
								'placeholder'  	=> isset( $element['placeholder'] )?esc_attr(  $element['placeholder']  ):'',
								'max_chars'  	=> isset( $element['max_chars'] )?absint( $element['max_chars'] ):'',
								'options'   	=> '',
								'rules'   		=> isset( $element['rules'] )?esc_html( json_encode( ( $element['rules'] ) ) ):'',
								'rules_type'   		=> isset( $element['rules_type'] )?esc_html( json_encode( ( $element['rules_type'] ) ) ):'',
								'id'    		=> 'tmcp_textfield_'.$tabindex.$form_prefix,
								'name'    		=> 'tmcp_'.$name_inc,
								'amount'     	=> '0 '.$_currency,
								'hide_amount'  	=> isset( $element['hide_amount'] )?" ".$element['hide_amount']:"",
								'tabindex'   	=> $tabindex
							);
							wc_get_template(
								$element['type'].'.php',
								$args ,
								$this->_namespace,
								$this->template_path
							);
							$element_counter++;
							break;
						case "select":
							$name_inc ="select_".$element_counter.$form_prefix;
							$tabindex++;

							$args = array(
								'options'   	=> '',
								'id'    		=> 'tmcp_select_'.$tabindex.$form_prefix,
								'name'    		=> 'tmcp_'.$name_inc,
								'amount'     	=> '0 '.$_currency,
								'hide_amount'  	=> isset( $element['hide_amount'] )?" ".$element['hide_amount']:"",
								'tabindex'   	=> $tabindex
							);

							foreach ( $element['options'] as $value=>$label ) {
								$args['options'] .='<option '.( isset( $_POST['tmcp_'.$name_inc] )?selected( $_POST['tmcp_'.$name_inc], esc_attr( sanitize_title( $value ) ), 0 ) :"" ).' value="'.esc_attr( sanitize_title( $value ) ).'" data-price="" data-rules="'.( isset( $element['rules'][$value] )?esc_html( json_encode( ( $element['rules'][$value] ) ) ):'' ).'" data-rulestype="'.( isset( $element['rules_type'][$value] )?esc_html( json_encode( ( $element['rules_type'][$value] ) ) ):'' ).'">'.wptexturize( apply_filters( 'woocommerce_tm_epo_option_name', $label ) ).'</option>';
							}
							wc_get_template(
								$element['type'].'.php',
								$args ,
								$this->_namespace,
								$this->template_path
							);
							$element_counter++;
							break;
						case "radio":
						case "checkbox":
							$items_per_row=(int) $element['items_per_row'];
							$grid_break="";
							$_percent=100;
							$_columns=0;
							if (!empty($items_per_row)){
								$_percent=(float) (100/$items_per_row);	
								$css_string=".element_".$element_counter." li{float:left !important;width:".$_percent."% !important;}";
								$css_string = str_replace(array("\r", "\n"), "", $css_string);								
								$this->inline_styles=$this->inline_styles.$css_string;
							}
							foreach ( $element['options'] as $value=>$label ) {
								$tabindex++;
								
								$_columns = $_columns +$_percent;
								$grid_break="";

								if ( $element['type']=='radio' ) {
									$name_inc ="radio_".$element_counter.$form_prefix;
								}
								if ( $element['type']=='checkbox' ) {
									$name_inc ="checkbox_".$element_counter."_".$field_counter.$form_prefix;
								}

								if ($_columns>100){
									$grid_break=" cpf_clear";
									$_columns=0;
								}

								$args = array(
									'label'   		=> wptexturize( apply_filters( 'woocommerce_tm_epo_option_name', $label ) ),
									'value'   		=> esc_attr( sanitize_title( $value ) ),
									'rules'   		=> isset( $element['rules'][$value] )?esc_html( json_encode( ( $element['rules'][$value] ) ) ):'',
									'rules_type'   		=> isset( $element['rules_type'][$value] )?esc_html( json_encode( ( $element['rules_type'][$value] ) ) ):'',
									'id'    		=> 'tmcp_choice_'.$element_counter."_".$field_counter."_".$tabindex.$form_prefix,
									'name'    		=> 'tmcp_'.$name_inc,
									'amount'     	=> '0 '.$_currency,
									'hide_amount'  	=> isset( $element['hide_amount'] )?" ".$element['hide_amount']:"",
									'use_images'	=> $element['use_images'],
									'tabindex'   	=> $tabindex,
									'grid_break'	=> $grid_break,
									'percent'		=> $_percent,
									'image'   		=> isset($element['images'][$field_counter])?$element['images'][$field_counter]:"",
									'limit' 		=> empty( $element['limit'] )?"":$element['limit']
								);
								wc_get_template(
									$element['type'].'.php',
									$args ,
									$this->_namespace,
									$this->template_path
								);
								$field_counter++;
							}
							$element_counter++;
							break;
						}

						wc_get_template(
							'builder-element-end.php',
							array(
								'element' => $element['type']
							) ,
							$this->_namespace,
							$this->template_path
						);

					}
				}
				$args = array(
					'column' 	=> $size,
					'style' 	=> $section['sections_style']
				);
				wc_get_template(
					'builder-section-end.php',
					$args ,
					$this->_namespace,
					$this->template_path
				);

			}

			wc_get_template(
				'builder-end.php',
				array() ,
				$this->_namespace,
				$this->template_path
			);

			$unit_counter++;

		}
		return array(
			'tabindex'   		=> $tabindex,
			'unit_counter'  	=> $unit_counter,
			'field_counter'  	=> $field_counter,
			'element_counter'  	=> $element_counter,
			'_currency'   		=> $_currency
		);

	}


	/**
	 * Handles the display of all the extra options on the product page.
	 */
	public function frontend_display($product_id=0, $form_prefix="") {
		global $product,$woocommerce;
		if ($woocommerce->product_factory===NULL){
			return;// bad function call
		}
		$this->tm_epo_fields($product_id, $form_prefix);
		$this->tm_epo_totals($product_id, $form_prefix);
	}

	public function tm_epo_totals($product_id=0, $form_prefix="") {
		global $product,$woocommerce;		
		if ($woocommerce->product_factory===NULL){
			return;// bad function call
		}
		$this->print_price_fields( $product_id, $form_prefix );		
	}

	public function tm_epo_fields($product_id=0,$form_prefix="") {
		global $woocommerce;
		if ($woocommerce->product_factory===NULL){
			return;// bad function call
		}
		if (!$product_id){
			global $product;
			if ($product){
				$product_id=$product->id;
			}
		}else{
			$product=get_product($product_id);
		}
		if (!$product_id || empty($product) ){
			return;
		}
		
		$post_id=$product_id;

		if ($form_prefix){	
			$form_prefix="_".$form_prefix;
			echo '<input type="hidden" class="cpf-bto-id" name="cpf_bto_id[]" value="'.$form_prefix.'" />';
			echo '<input type="hidden" value="" name="cpf_bto_price[]" class="cpf-bto-price" />';
			echo '<input type="hidden" value="0" name="cpf_bto_optionsprice[]" class="cpf-bto-optionsprice" />';
		}
		$cpf_price_array  = $this->get_product_tm_epos( $post_id );
		if (!$cpf_price_array){
			return;
		}
		$global_price_array = $cpf_price_array['global'];
		$local_price_array  = $cpf_price_array['local'];

		if ($this->tm_meta_cpf['exclude']){
			$global_price_array=array();
		}

		$global_prices=array( 'before'=>array(), 'after'=>array() );
		foreach ( $global_price_array as $priority=>$priorities ) {
			foreach ( $priorities as $pid=>$field ) {
				if (isset($field['sections']) && is_array($field['sections'])){
					foreach ( $field['sections'] as $section_id=>$section ) {
						if ( isset( $section['sections_placement'] ) ) {
							$global_prices[$section['sections_placement']][$priority][$pid]['sections'][$section_id]=$section;
						}
					}
				}
			}
		}


		$tabindex   		= 0;
		$_currency   		= get_woocommerce_currency_symbol();
		$unit_counter  		= 0;
		$field_counter  	= 0;
		$element_counter	= 0;

		wc_get_template(
			'start.php',
			array() ,
			$this->_namespace,
			$this->template_path
		);

		// global options before local
		foreach ( $global_prices['before'] as $priorities ) {
			foreach ( $priorities as $field ) {
				$args=array(
					'tabindex'   		=> $tabindex,
					'unit_counter'  	=> $unit_counter,
					'field_counter'  	=> $field_counter,
					'element_counter'  	=> $element_counter,
					'_currency'   		=> $_currency
				);
				$_return=$this->get_builder_display( $field, 'before', $args , $form_prefix);
				extract( $_return, EXTR_OVERWRITE );
			}
		}

		// local options
		if ( is_array( $local_price_array ) && sizeof( $local_price_array ) > 0 ) {

			$attributes = maybe_unserialize( get_post_meta( $post_id, '_product_attributes', true ) );

			if ( is_array( $attributes ) && count( $attributes )>0 ) {
				foreach ( $local_price_array as $field ) {
					if ( isset( $field['name'] ) && isset( $attributes[$field['name']] ) && !$attributes[$field['name']]['is_variation'] ) {

						$attribute=$attributes[$field['name']];

						$empty_rules="";
						if ( isset( $field['rules'][0] ) ) {
							$empty_rules=esc_html( json_encode( ( $field['rules'][0] ) ) );
						}
						$empty_rules_type="";
						if ( isset( $field['rules_type'][0] ) ) {
							$empty_rules_type=esc_html( json_encode( ( $field['rules_type'][0] ) ) );
						}

						$args = array(
							'title'  	=> ( !$attribute['is_taxonomy'] && isset($attributes[$field['name']]["name"]))?esc_html($attributes[$field['name']]["name"]):esc_html( wc_attribute_label( $field['name'] ) ),
							'required'  => esc_html( wc_attribute_label( $field['required'] ) ),
							'field_id'  => 'tm-epo-field-'.$unit_counter,
							'type'      => $field['type'],
							'rules'     => $empty_rules,
							'rules_type'     => $empty_rules_type
						);
						wc_get_template(
							'field-start.php',
							$args ,
							$this->_namespace,
							$this->template_path
						);

						$name_inc="";
						$field_counter=0;
						if ( $attribute['is_taxonomy'] ) {
						
							$all_terms = get_terms( $attribute['name'] , 'orderby=name&hide_empty=0' );
							
							switch ( $field['type'] ) {

							case "select":
								$name_inc ="select_".$element_counter;
								$tabindex++;

								$args = array(
									'options'   	=> '',
									'id'    		=> 'tmcp_select_'.$tabindex.$form_prefix,
									'name'    		=> 'tmcp_'.$name_inc.$form_prefix,
									'amount'     	=> '0 '.$_currency,
									'hide_amount'  	=> !empty( $field['hide_price'] )?" hidden":"",
									'tabindex'   	=> $tabindex
								);
								if ( $all_terms ) {
					                foreach ( $all_terms as $term ) {
					                    $has_term = has_term( (int) $term->term_id, $attribute['name'], $post_id ) ? 1 : 0;
					                    if ($has_term ){
					                    	$args['options'] .='<option '.( isset( $_POST['tmcp_'.$name_inc.$form_prefix] )?selected( $_POST['tmcp_'.$name_inc.$form_prefix], esc_attr( sanitize_title( $term->slug ) ), 0 ) :"" ).' value="'.sanitize_title( $term->slug ).'" data-price="" data-rules="'.( isset( $field['rules'][$term->slug] )?esc_html( json_encode( ( $field['rules'][$term->slug] ) ) ):'' ).'" data-rulestype="'.( isset( $field['rules_type'][$term->slug] )?esc_html( json_encode( ( $field['rules_type'][$term->slug] ) ) ):'' ).'">'.wptexturize( $term->name ).'</option>';					                        
					                    }
					                }
					            }
								
								wc_get_template(
									$field['type'].'.php',
									$args ,
									$this->_namespace,
									$this->template_path
								);
								$element_counter++;
								break;

							case "radio":
							case "checkbox":
								if ( $all_terms ) {
									foreach ( $all_terms as $term ) {
										$has_term = has_term( (int) $term->term_id, $attribute['name'], $post_id ) ? 1 : 0;
										if ($has_term ){
								
											$tabindex++;

											if ( $field['type']=='radio' ) {
												$name_inc ="radio_".$element_counter;
											}
											if ( $field['type']=='checkbox' ) {
												$name_inc ="checkbox_".$element_counter."_".$field_counter;
											}

											$args = array(
												'label'   		=> wptexturize( $term->name ),
												'value'   		=> sanitize_title( $term->slug ),
												'rules'   		=> isset( $field['rules'][$term->slug] )?esc_html( json_encode( ( $field['rules'][$term->slug] ) ) ):'',
												'rules_type'   		=> isset( $field['rules_type'][$term->slug] )?esc_html( json_encode( ( $field['rules_type'][$term->slug] ) ) ):'',
												'id'    		=> 'tmcp_choice_'.$element_counter."_".$field_counter."_".$tabindex.$form_prefix,
												'name'    		=> 'tmcp_'.$name_inc.$form_prefix,
												'amount'     	=> '0 '.$_currency,
												'hide_amount'  	=> !empty( $field['hide_price'] )?" hidden":"",
												'tabindex'   	=> $tabindex,
												'use_images'	=> "",
												'grid_break'	=> "",
												'percent'		=> "",
												'limit' 		=> empty( $field['limit'] )?"":$field['limit']
											);
											wc_get_template(
												$field['type'].'.php',
												$args ,
												$this->_namespace,
												$this->template_path
											);

											$field_counter++;
										}
					                }
					            }								

								$element_counter++;
								break;

							}
						} else {

							$options = array_map( 'trim', explode( WC_DELIMITER, $attribute['value'] ) );

							switch ( $field['type'] ) {

							case "select":
								$name_inc ="select_".$element_counter;
								$tabindex++;

								$args = array(
									'options'   	=> '',
									'id'    		=> 'tmcp_select_'.$tabindex.$form_prefix,
									'name'    		=> 'tmcp_'.$name_inc.$form_prefix,
									'amount'     	=> '0 '.$_currency,
									'hide_amount'  	=> !empty( $field['hide_price'] )?" hidden":"",
									'tabindex'   	=> $tabindex
								);
								foreach ( $options as $option ) {
									$args['options'] .='<option '.( isset( $_POST['tmcp_'.$name_inc.$form_prefix] )?selected( $_POST['tmcp_'.$name_inc.$form_prefix], esc_attr( sanitize_title( $option ) ), 0 ) :"" ).' value="'.esc_attr( sanitize_title( $option ) ).'" data-price="" data-rules="'.( isset( $field['rules'][esc_attr( sanitize_title( $option ) )] )?esc_html( json_encode( ( $field['rules'][esc_attr( sanitize_title( $option ) )] ) ) ):'' ).'" data-rulestype="'.( isset( $field['rules_type'][esc_attr( sanitize_title( $option ) )] )?esc_html( json_encode( ( $field['rules_type'][esc_attr( sanitize_title( $option ) )] ) ) ):'' ).'">'.wptexturize( apply_filters( 'woocommerce_tm_epo_option_name', $option ) ).'</option>';
								}
								wc_get_template(
									$field['type'].'.php',
									$args ,
									$this->_namespace,
									$this->template_path
								);
								$element_counter++;
								break;

							case "radio":
							case "checkbox":
								foreach ( $options as $option ) {
									$tabindex++;

									if ( $field['type']=='radio' ) {
										$name_inc ="radio_".$element_counter;
									}
									if ( $field['type']=='checkbox' ) {
										$name_inc ="checkbox_".$element_counter."_".$field_counter;
									}

									$args = array(
										'label'   		=> wptexturize( apply_filters( 'woocommerce_tm_epo_option_name', $option ) ),
										'value'   		=> esc_attr( sanitize_title( $option ) ),
										'rules'   		=> isset( $field['rules'][sanitize_title( $option )] )?esc_html( json_encode( ( $field['rules'][sanitize_title( $option )] ) ) ):'',
										'rules_type'   		=> isset( $field['rules_type'][sanitize_title( $option )] )?esc_html( json_encode( ( $field['rules_type'][sanitize_title( $option )] ) ) ):'',
										'id'    		=> 'tmcp_choice_'.$element_counter."_".$field_counter."_".$tabindex.$form_prefix,
										'name'    		=> 'tmcp_'.$name_inc.$form_prefix,
										'amount'     	=> '0 '.$_currency,
										'hide_amount'  	=> !empty( $field['hide_price'] )?" hidden":"",
										'tabindex'   	=> $tabindex,
										'use_images'	=> "",
										'grid_break'	=> "",
										'percent'		=> "",
										'limit' 		=> empty( $field['limit'] )?"":$field['limit']
									);
									wc_get_template(
										$field['type'].'.php',
										$args ,
										$this->_namespace,
										$this->template_path
									);
									$field_counter++;
								}
								$element_counter++;
								break;

							}
						}

						wc_get_template(
							'field-end.php',
							array() ,
							$this->_namespace,
							$this->template_path
						);

						$unit_counter++;
					}
				}
			}
		}

		// global options after local
		foreach ( $global_prices['after'] as $priorities ) {
			foreach ( $priorities as $field ) {
				$args=array(
					'tabindex'   		=> $tabindex,
					'unit_counter'  	=> $unit_counter,
					'field_counter'  	=> $field_counter,
					'element_counter'  	=> $element_counter,
					'_currency'   		=> $_currency
				);
				$_return=$this->get_builder_display( $field, 'after', $args, $form_prefix );
				extract( $_return, EXTR_OVERWRITE );
			}
		}

		wc_get_template(
			'end.php',
			array() ,
			$this->_namespace,
			$this->template_path
		);

		$this->tm_add_inline_style();
		

	}

	public function frontend_scripts() {
		global $product;
		if ( is_product() || is_cart() || is_checkout() || is_order_received_page() ) {
			$this->custom_frontend_scripts();	
		}else{
			return;
		}		
	}

	public function custom_frontend_scripts() {	
		$product = get_product();

        wp_enqueue_style( 'tm-font-awesome', $this->plugin_url .'/external/font-awesome/css/font-awesome.min.css', false, '4.1', 'screen' );
        wp_enqueue_style( 'tm-epo-animate-css', $this->plugin_url  . '/css/animate.css' );
		wp_enqueue_style( 'tm-epo-css', $this->plugin_url . '/css/tm-epo.css' );

		wp_register_script( 'tm-accounting', $this->plugin_url . '/js/accounting.min.js', '', '0.3.2' );
		wp_register_script( 'tm-modernizr', $this->plugin_url. '/js/modernizr.js', '', '2.8.2' );
		wp_register_script( 'tm-scripts', $this->plugin_url . '/js/tm-scripts.js', '', '1.0' );

		wp_enqueue_script( 'tm-epo', $this->plugin_url. '/js/tm-epo.js', array( 'jquery', 'tm-accounting', 'tm-modernizr', 'tm-scripts' ), $this->version, true );

		$extra_fee=0;
		$args = array(
			'extra_fee' 					=> apply_filters( 'woocommerce_tm_final_price_extra_fee', $extra_fee,$product ),
			'tm_epo_final_total_box' 		=> $this->tm_epo_final_total_box,
			'i18n_extra_fee'           		=> __( 'Extra fee', TM_EPO_TRANSLATION ),
			'i18n_options_total'           	=> __( 'Options amount', TM_EPO_TRANSLATION ),
			'i18n_final_total'             	=> __( 'Final total', TM_EPO_TRANSLATION ),
			'i18n_cancel'					=> __( 'Cancel', TM_EPO_TRANSLATION ),
			'i18n_close'					=> __( 'Close', TM_EPO_TRANSLATION ),
			'i18n_addition_options'			=> __( 'Additional Options', TM_EPO_TRANSLATION ),
			'currency_format_num_decimals' 	=> absint( get_option( 'woocommerce_price_num_decimals' ) ),
			'currency_format_symbol'       	=> get_woocommerce_currency_symbol(),
			'currency_format_decimal_sep'  	=> esc_attr( stripslashes( get_option( 'woocommerce_price_decimal_sep' ) ) ),
			'currency_format_thousand_sep' 	=> esc_attr( stripslashes( get_option( 'woocommerce_price_thousand_sep' ) ) ),
			'currency_format'              	=> esc_attr( str_replace( array( '%1$s', '%2$s' ), array( '%s', '%v' ), get_woocommerce_price_format() ) )
		);
		wp_localize_script( 'tm-epo', 'tm_epo_js', $args );
	}

	private function print_price_fields( $product_id=0, $form_prefix="") {		
		if (!$product_id){
			global $product;
			if ($product){
				$product_id=$product->id;
			}
		}else{
			$product=get_product($product_id);
		}
		if (!$product_id || empty($product) ){
			return;
		}

		if ($form_prefix){	
			$form_prefix="_".$form_prefix;
		}

		if (class_exists('WC_Dynamic_Pricing')){
			$id = isset($product->variation_id) ? $product->variation_id : $product->id;
			$dp=WC_Dynamic_Pricing::instance();
			$price= $dp->discounted_products[$id];
		}else{
			$price=$product->get_price();
		}

		$variations = array();

		foreach ( $product->get_children() as $child_id ) {

			$variation = $product->get_child( $child_id );
			if ( ! $variation->exists() ){
				continue;
			}
			$variations[$child_id] = $variation->get_price();

		}

		wc_get_template(
			'totals.php',
			array(
				'variations' =>esc_html(json_encode( (array) $variations ) ),
				'hidden' => ($this->tm_epo_final_total_box=='hide')?' hidden':'',
				'form_prefix'=> $form_prefix,
				'type'  => esc_html( $product->product_type ),
				'price' => esc_html( ( is_object( $product ) ? apply_filters( 'woocommerce_tm_final_price', $price,$product ) : '' ) )
			) ,
			$this->_namespace,
			$this->template_path
		);
	}

	private function tm_add_inline_style(){	
		echo '<style type="text/css">';
		echo $this->inline_styles;
		echo '</style>';
	}

	public function upload_file($file) {
		include_once( ABSPATH . 'wp-admin/includes/file.php' );
		include_once( ABSPATH . 'wp-admin/includes/media.php' );
		add_filter( 'upload_dir',  array( $this, 'upload_dir_trick' ) );
		$upload = wp_handle_upload( $file, array( 'test_form' => false ) );
		remove_filter( 'upload_dir',  array( $this, 'upload_dir_trick' ) );
		return $upload;
	}

	public function upload_dir_trick( $param ) {
		global $woocommerce;
		$dir="/extra_product_options/";
		$unique_dir=md5( $woocommerce->session->get_customer_id() );
		if ( empty( $param['subdir'] ) ) {
			$param['path']   = $param['path'] . $dir . $unique_dir;
			$param['url']    = $param['url']. $dir . $unique_dir;
			$param['subdir'] = $dir . $unique_dir;
		} else {
			$subdir             = $dir . $unique_dir;
			$param['path']   = str_replace( $param['subdir'], $subdir, $param['path'] );
			$param['url']    = str_replace( $param['subdir'], $subdir, $param['url'] );
			$param['subdir'] = str_replace( $param['subdir'], $subdir, $param['subdir'] );
		}
		return $param;
	}	

}
?>
