<?php

/**
 * OAuth storage handler built on wpdb
 * @package Dropbox\Oauth
 * @subpackage Storage
 */
namespace Dropbox\OAuth\Storage;

class DB extends Session
{
    /**
     * Default database table
     * Override this using setTable()
     * @var string
     */
    protected $table = SNS_DROPBOX_TABLE;
    
    /**
     * Construct the parent object and
     * set the authenticated user ID
     * @param \Dropbox\OAuth\Storage\Encrypter $encrypter
     * @param int $userID
     * @throws \Dropbox\Exception
     */
    public function __construct(Encrypter $encrypter = null, $userID)
    {
        // Construct the parent object so we can access the SESSION
        // instead of querying the database on every request
        parent::__construct($encrypter, $userID);
    }

    /**
     * Set the table to store OAuth tokens in
     * If the table does not exist, the get() method will attempt to create it when it is called.
     * @todo Check for valid table name and quote it (see below)
     * @link http://dev.mysql.com/doc/refman/5.0/en/identifiers.html
     * @return void
     */
    public function setTable($table)
    {
        $this->table = $table;
    }
    
    /**
     * Get an OAuth token from the database or session (see below)
     * Request tokens are stored in the session, access tokens in the database
     * Once a token is retrieved it will be stored in the users session
     * for subsequent requests to reduce overheads
     * @param string $type Token type to retrieve
     * @return array|bool
     */
    public function get($type)
    {
        global $wpdb;
        if ($type != 'request_token' && $type != 'access_token') {
            throw new \Dropbox\Exception("Expected a type of either 'request_token' or 'access_token', got '$type'");
        } elseif ($type == 'request_token') {
            return parent::get($type);
        } elseif ($token = parent::get($type)) {
            return $token;
        } else {
            $query_str = "SELECT
                            `uid`,
                            `user_id`,
                            `token`
                          FROM {$this->table}
                          WHERE `user_id` = {$this->userID}
                          LIMIT 1";

            $data = $wpdb->get_results( $query_str , ARRAY_A );
            if ( !empty( $data ) ) {
                $token = $this->decrypt($data[0]['token']);
                $_SESSION[$this->namespace][$this->userID][$type] = $data[0]['token'];
                return $token;
            }
            return false;
        }
    }

    public function getData(){
        global $wpdb;
        $query_str = "SELECT
                            `uid`,
                            `user_id`,
                            `display_name`,
                            `email`
                          FROM {$this->table}
                          WHERE `user_id` = {$this->userID}
                          LIMIT 1";

        $data = $wpdb->get_results( $query_str , ARRAY_A );
        return (empty($data))?$data:$data[0];
    }

    /**
     * Set an OAuth token in the database or session (see below)
     * Request tokens are stored in the session, access tokens in the database
     * @param \stdClass Token object to set
     * @param string $type Token type
     * @return void
     */
    public function set($token, $type)
    {
        global $wpdb;
        if ($type != 'request_token' && $type != 'access_token') {
            $message = "Expected a type of either 'request_token' or 'access_token', got '$type'";
            throw new \Dropbox\Exception($message);
        } elseif ($type == 'request_token') {
            parent::set($token, $type);
        } else {
            $token = $this->encrypt($token);
            $query = 'INSERT INTO ' . $this->table . ' (user_id, token) VALUES ('.$this->userID.",'".$token."') ON DUPLICATE KEY UPDATE token = '".$token."'";
            $wpdb->query( $query );
            $_SESSION[$this->namespace][$this->userID][$type] = $token;
        }
    }
    
    /**
     * Delete access token for the current user ID from the database
     * @return bool
     */
    public function delete( $db = true )
    {
        global $wpdb;
        parent::delete();
        if( !$db ) return true;
        $query = 'DELETE FROM ' . $this->table . ' WHERE user_id = '.$this->userID;
        $res = $wpdb->query($query);
        return (($res)!==false && $res>0)?true:false;
    }

    public function update( $info )
    {
        global $wpdb;
        $query = 'UPDATE ' . $this->table . " SET display_name = '".$info['display_name']."', email = '".$info['email']."' WHERE user_id = ".$this->userID;
        return ($wpdb->query($query) === false)?false:true;
    }

}
