/*
 * productColorizer - jQuery Plugin
 * version: 1.2 October 2012 - OptArt edition
 * @requires jQuery v1.6 or later
 *
 * Examples at http://nikorablin.com/sandbox/productColorizer/
 * Free to use and abuse under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 *
 * Please note that this plugin was modified by OptArt, so it works a different
 * way than original one. The original plugin is available in GIT history, in
 * case when needed.
 */

(function($){
    $.fn.productColorizer = function( options ) {

		// defaults
		var defaults = {
			transparency: 0.55,
			swatchTransparency: 0.75,
			secondaryTransparency: 0.55,
            attributeSlug: 'colorizer-color',
            defaultColor: '255,255,255',
            maskId: '#mask'
		};
		// extend defaults
		var options = $.extend(defaults, options);

		return this.each(function() {

			// init objects
			var o = options,
                mask = $( o.maskId );

			// set background color of mask with rel values and transparency
            $( 'table.variations' ).on( 'change', '#pa_' + o.attributeSlug, function(){

                var color_object = $( '#colorizer-color-' + $( this ).val() ),
                    rgb_color = color_object.length ? color_object.val() : o.defaultColor,
                    color = "rgba(" + rgb_color + "," + o.transparency + ")";
console.log($( this ).val());
                mask.css( {"background-color": color}, 1000 );
                if( $.browser.msie ) {
                    var hex_color = colorToHex( rgb_color.split( "," ) );
                    mask.css({
                        background: 'transparent',
                        zoom: 1,
                        filter: 'progid:DXImageTransform.Microsoft.gradient(startColorstr=#80' + hex_color + ',endColorstr=#80' + hex_color + ')'
                    });
                }
            });

            //rgb to hex
            function colorToHex( color ) {

                var red = parseInt( color[0] );
                var green = parseInt( color[1] );
                var blue = parseInt( color[2] );

                var rgb = blue | ( green << 8 ) | ( red << 16 );
                return rgb.toString( 16 );
            };
        });
    }
})(jQuery);